#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qpixmap.h>

#include <tulip/GlGraphWidget.h>
#include <tulip/MouseObject.h>

#include "Application.h"
#include "NavigateGlGraph.h"
#include "NavigateButton.h"

/* 
 *  Constructs a NavigateGlGraph which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
NavigateGlGraph::NavigateGlGraph( QWidget* parent,  const char* name, SuperGraph *graph, WFlags fl )
    : NavigateGlGraphData( parent, name, fl )
{
  QPixmap *pix1=new QPixmap( (((Application *)qApp)->bitmapPath +"but1.xpm").c_str() );
  QPixmap *pix2=new QPixmap( (((Application *)qApp)->bitmapPath +"but2.xpm").c_str() );
  QPixmap *pix3=new QPixmap( (((Application *)qApp)->bitmapPath +"but3.xpm").c_str() );
  MyCustomWidget1->setBackgroundPixmap(*pix1);
  MyCustomWidget2->setBackgroundPixmap(*pix3);
  MyCustomWidget3->setBackgroundPixmap(*pix2);
  MyCustomWidget1->setGlGraphWidget(glWidget1);
  MyCustomWidget2->setGlGraphWidget(glWidget1);
  MyCustomWidget3->setGlGraphWidget(glWidget1);
  MyCustomWidget1->setMouseObject(new MouseMove());
  MyCustomWidget2->setMouseObject(new MouseZoomRotZ());
  MyCustomWidget3->setMouseObject(new MouseRotXRotY());
  glWidget1->setSuperGraph(graph);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
NavigateGlGraph::~NavigateGlGraph()
{
    // no need to delete child widgets, Qt does it all for us
}

GlGraphWidget *NavigateGlGraph::getGlGraphWidget() const
{
  return glWidget1;
}
/* 
 * public slot
 */
void NavigateGlGraph::update()
{
    qWarning( "NavigateGlGraph::update() not yet implemented!" ); 
}



