#include "tulip/GlDrawable.h"

using namespace std;

typedef set<GlDrawable *>::const_iterator IT;

GlDrawableComposite::~GlDrawableComposite() {
  for (IT it=elements.begin();it!=elements.end();++it) {
    delete (*it);
  }
}

void GlDrawableComposite::draw(GlGraph *gl) {
  for (IT it=elements.begin();it!=elements.end();++it) {
    (*it)->draw(gl);
  }
}

void GlDrawableComposite::add(GlDrawable *element) {
  elements.insert(element);
}

void GlDrawableComposite::del(GlDrawable *element) {
  elements.erase(element);
  delete element;
}
