#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <sstream>
#include <GL/gl.h>
#include <GL/glu.h>

#include <tulip/SelectionProxy.h>
#include <tulip/StringProxy.h>
#include <tulip/MetricProxy.h>
#include <tulip/MetaGraphProxy.h>
#include <tulip/IntProxy.h>
#include <tulip/LayoutProxy.h>
#include <tulip/SizesProxy.h>
#include "tulip/GlLines.h"
#include "tulip/GlGraph.h"
#include "tulip/Glyph.h"

using namespace std;

//this is used to sort node or edges from a select buffer according to their depth
template<class Element>
struct lessElementZ : public std::binary_function<Element, Element, bool> {
  GLuint (*v)[4];
  GLint hits;
  bool operator()(Element e1, Element e2) {
    GLuint z1, z2;
    for (int i=0; i<hits; ++i) {
      if (e1.id == v[i][3]) z1 = v[i][1]/2 + v[i][2]/2;
      if (e2.id == v[i][3]) z2 = v[i][1]/2 + v[i][2]/2;
    }
    return z1 < z2;
  }
};

//=====================================================
//Selection d'objet dans le monde 3D
//=====================================================
void GlGraph::initDoSelect(GLint x, GLint y, GLint w,GLint h) {
  strategy->MakeCurrent();
  selectBuf=new GLuint[(_superGraph->numberOfEdges()+_superGraph->numberOfNodes())][4];
  glSelectBuffer((_superGraph->numberOfEdges()+_superGraph->numberOfNodes())*4 , (GLuint *)selectBuf);
  glRenderMode(GL_SELECT);
  glInitNames();
  glPushName(~0);
  //  glViewport(0, 0, winW, winH);
  //  glGetIntegerv(GL_VIEWPORT, vp);
  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  gluPickMatrix(x, y, w, h, viewportArray);
  initProjection(false);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glPolygonMode(GL_FRONT, GL_FILL);
  glDisable(GL_LIGHTING);
  glDisable(GL_BLEND);
  initModelView();
}
//=====================================================
void GlGraph::endSelect() {
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
  glGetDoublev (GL_PROJECTION_MATRIX, modelviewMatrix);
  glMatrixMode(GL_PROJECTION);
  glPopMatrix();
  glGetDoublev (GL_PROJECTION_MATRIX, projectionMatrix);
  glRenderMode(GL_RENDER);
}
//=====================================================
bool GlGraph::doNodeSelect(GLint x, GLint y,const int w , const int h, set<node> &sNode) {
  if (_superGraph==0) return false;
  GLint hits;
  initDoSelect(x,y,w,h);
  makeNodeSelect(0);
  glFlush();
  hits = glRenderMode(GL_RENDER);
  if (hits <= 0) {delete [] selectBuf; endSelect(); return false;}
  while(hits>0) {
    node tmp;
    tmp.id = selectBuf[hits-1][3];
    sNode.insert(tmp);
    hits--;
  }
  delete [] selectBuf;
  endSelect();
  return true;
}
//=====================================================
bool GlGraph::doNodeSelect(const int x, const int y, vector<node> &vNode) {
  if (_superGraph==0) return false;
  GLint hits;
  initDoSelect(x,y,4,4);
  makeNodeSelect(0);
  glFlush();
  hits = glRenderMode(GL_RENDER);
  if (hits <= 0) {delete [] selectBuf; endSelect(); return false;}
  struct lessElementZ<node> comp;
  comp.v = selectBuf;
  comp.hits = hits;
  while(hits>0) {
    node tmp;
    tmp.id = selectBuf[hits-1][3];
    vNode.push_back(tmp);
    hits--;
  }
  sort(vNode.begin(), vNode.end(), comp);
  delete [] selectBuf;
  endSelect();
  return true;
}
//=====================================================
bool GlGraph::doEdgeSelect(GLint x, GLint y,const int w , const int h, set<edge> &sEdge) {
  if (_superGraph==0) return false;
  GLint hits;
  initDoSelect(x,y,w,h);
  makeEdgeSelect(0);
  glFlush();
  hits = glRenderMode(GL_RENDER);
  if (hits <= 0) {delete [] selectBuf; endSelect(); return false;}
  while(hits>0) {
    edge tmp;
    tmp.id = selectBuf[hits-1][3];;
    sEdge.insert(tmp);
    hits--;
  }
  delete [] selectBuf;
  endSelect();
  return true;
}
//=====================================================
bool GlGraph::doEdgeSelect(const int x, const int y, vector<edge> &vEdge) {
  if (_superGraph==0) return false;
  GLint hits;
  initDoSelect(x,y,4,4);
  makeEdgeSelect(0);
  glFlush();
  hits = glRenderMode(GL_RENDER);
  if (hits <= 0) {delete [] selectBuf; endSelect(); return false;}
  struct lessElementZ<edge> comp;
  comp.v = selectBuf;
  comp.hits = hits;
  while(hits>0) {
    edge tmp;
    tmp.id = selectBuf[hits-1][3];;
    vEdge.push_back(tmp);
    hits--;
  }
  sort(vEdge.begin(), vEdge.end(), comp);
  delete [] selectBuf;
  endSelect();
  return true;
}
//=====================================================
void GlGraph::doSelect(const int x, const int y, const int w ,const int h,
                       set<node> &sNode, set<edge> &sEdge) {
#ifndef NDEBUG
  cerr << "bool GlGraph::doSelectALL" << endl;
#endif
  strategy->timerStop();
  strategy->MakeCurrent();
  glPushAttrib(GL_ALL_ATTRIB_BITS); 
  doNodeSelect(x,y,w,h,sNode);
  doEdgeSelect(x,y,w,h,sEdge);
  glPopAttrib();
  strategy->timerStart(0);
  //  cerr << "bool GlGraph::doSelect End" << endl;
}

bool GlGraph::doSelect(GLint x, GLint y, tlp::ElementType &type ,node &n, edge &e ) {
#ifndef NDEBUG
  cerr << __PRETTY_FUNCTION__ << endl;
#endif
  strategy->timerStop();
  strategy->MakeCurrent();
  glPushAttrib(GL_ALL_ATTRIB_BITS); 
  bool result;
  vector<node> tmpSetNode;
  result=doNodeSelect(x+2, winH-y-2, tmpSetNode);
  if (result){
    n=(*(tmpSetNode.begin()));
    type = tlp::NODE;
  }
  else { 
    type = tlp::EDGE;
    vector<edge> tmpSetEdge;
    result=doEdgeSelect(x+2, winH-y-2, tmpSetEdge);
    if (result) e=(*(tmpSetEdge.begin()));
  }
  glPopAttrib();
  strategy->timerStart(0);
  return result;
  //  cerr << "bool GlGraph::doSelect End" << endl;
}
//====================================lines================
//Construction des objets avec affectation de nom
//======================================================================
//Placement des sommets du graphe  l'index i=startIndex..startIndex+n-1
void GlGraph::makeNodeSelect(int startIndex) {
  glMatrixMode(GL_MODELVIEW);
  //  int i=startIndex;
  glPushAttrib(GL_ALL_ATTRIB_BITS);
  Iterator<node> *itN=_superGraph->getNodes();
  while (itN->hasNext()) {
    node itv=itN->next();
    const Size &nSize=elementSize->getNodeValue(itv);
    if( nSize == Size(0,0,0) )	continue;
    const Coord &tmpCoord = elementLayout->getNodeValue(itv);	  
    //    float lod= projectSize(tmpCoord, nSize);
    //    float lod = 100.0;
    //    if (lod==0) continue;
    glLoadName(itv.id);
    /*    if (lod < 8.0) { //less than four pixel on screen
	  glPointSize(4);
	  glBegin(GL_POINTS);
	  glVertex3f(tmpCoord[0], tmpCoord[1], tmpCoord[2]);
	  glEnd();
	  }
	  else {*/
    glPushMatrix();
    glTranslatef( tmpCoord.getX() , tmpCoord.getY() , tmpCoord.getZ() );
    glScalef(nSize.getW(), nSize.getH(), nSize.getD());
    if (elementMetaGraph->getNodeValue(itv) == 0)
      glyphs.get(elementShape->getNodeValue(itv))->draw(itv);
    else
      glyphs.get(0)->draw(itv);
    glPopMatrix();
      // }
    //    ++i;
  } delete itN;
  glPopAttrib();
}
//=================================================================
//Placement des artes du graphe  l'index i=startIndex..startIndex+n-number_of_edges
void GlGraph::makeEdgeSelect(int startIndex) {
  if (!_displayEdges) return;
  glMatrixMode(GL_MODELVIEW);
  int i=startIndex;
  static const Color tmpColor(255,255,255,100);
  Iterator<edge> *itE=_superGraph->getEdges();
  while (itE->hasNext()) {
    edge ite=itE->next();
    glLoadName(ite.id);
    const Coord &tmpCoord=elementLayout->getNodeValue(_superGraph->source(ite));
    const Coord &tmpCoord2=elementLayout->getNodeValue(_superGraph->target(ite));
    const LineType::RealType &lCoord=elementLayout->getEdgeValue(ite);
    Coord startCoord = (lCoord.size() == 0 ? tmpCoord2 : lCoord.front());
    Coord finalCoord = (lCoord.size() == 0 ? tmpCoord : lCoord.back());
    drawEdge(startCoord, finalCoord, tmpCoord, lCoord, tmpCoord2,
             tmpColor, tmpColor, elementSize->getEdgeValue(ite), elementShape->getEdgeValue(ite), 
	     false);
    ++i;
  } delete itE;
}
