//-*-c++-*-
/**
 Author: David Auber, Sebastien Grivet
 Email : auber@labri.fr,grivet@labri.fr
 Last modification : 06/02/2002
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#include <TlpTools.h>
#include <MetaGraphProxy.h>
#include <PluginLoaderTxt.h>
/**
   Little tutorial program which creates a complete graph with
   K nodes.
 */

using namespace tlp;

//Number of elements of the graph.
const unsigned int GSIZE=10;

int main(int argc, char* argv[]) {
  PluginLoaderTxt mypl;
  loadPlugins(&mypl);
  //Create a new SuperGraph
  SuperGraph *sp=newSuperGraph();
  //Add GSIZE nodes into the graph
  for (unsigned int i=0;i<GSIZE;++i) sp->addNode();
  //Get an iterator on all the nodes of the graph
  Iterator<node> *it1=sp->getNodes();
  for (;it1->hasNext();){
    node n1=it1->next();
    Iterator<node> *it2=sp->getNodes();
    for (;it2->hasNext();){
      node n2=it2->next();
      //create an edge for each couple of different nodes.
      if (n1!=n2) sp->addEdge(n1,n2);
    }delete it2;
  }delete it1;


  SuperGraph *superGraph=sp;
  //create 5 graphs
  vector<SuperGraph *> subgraph(5);
  for (int i=0;i < 5 ; ++i)  subgraph[i]=tlp::newSubGraph(superGraph);
  
  //create metagraph
  for (int i=0;i<4;++i) subgraph[4]->addNode();	
  
  MetaGraphProxy *metaGraphProxy=getLocalProxy<MetaGraphProxy>(subgraph[4],"viewMetaGraph");

  MetricProxy *values=getLocalProxy<MetricProxy>(superGraph,"MinDistance",cached,result,errMsg);

  Iterator<node> *itN=subgraph[4]->getNodes();
  for (int j=0;itN->hasNext();++j) {
    node itn=itN->next();
    metaGraphProxy->setNodeValue(itn,subgraph[j]);
    subgraph[j]->addNode();
  }delete itN;

  //Write the graph on the standard output.
  std::cout << sp;  
}

