//-*-c++-*-
/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify  *
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifndef _SELECTION_H
#define _SELECTION_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Types.h"
#include "Property.h"

class PropertyContext;
class SelectionProxy;

/**
 * \defgroup plugins
 */ 
/*@{*/

/// Interface for selection plug-ins
class TLP_SCOPE Selection:public Property<BooleanType , BooleanType>
{ 
  ///
  friend class SelectionProxy;
public:
  /** This Selection proxy is the one associated to the plug-ins,
      The data should be store in it*/
  SelectionProxy *selectionProxy;

protected:
  ///
  Selection (const PropertyContext &);
  ///
  virtual ~Selection(){}
};
/*@*/
#endif









