//-*-c++-*-
/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>

#include <tulip/SuperGraph.h>
#include <tulip/PropertyManager.h>
#include <tulip/SelectionProxy.h>
#include <tulip/MetricProxy.h>
#include <tulip/GlGraphWidget.h>

#include "MouseMagicSelection.h"

using namespace std;
using namespace tlp;

MouseMagicSelection::MouseMagicSelection():
  x(0),y(0),w(0),h(0),started(false),superGraph(0)
{}

void MouseMagicSelection::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){
  if (qMouseEv->button()==QEvent::LeftButton) {
    x=qMouseEv->x();
    y=qMouseEv->y();
    ElementType type;
    node tmpNode;
    edge tmpEdge;
    glGraphWidget->getGlGraph()->doSelect(x, y, type, tmpNode, tmpEdge);
    if (type != NODE) {
      cerr << __PRETTY_FUNCTION__ << ": type != NODE" << endl;
      return;
    }
    Observable::holdObservers();
    superGraph=glGraphWidget->getGlGraph()->getSuperGraph();
    SelectionProxy *selection=superGraph->getProperty<SelectionProxy>("viewSelection");
    SelectionProxy *visited=superGraph->getProperty<SelectionProxy>("tmpVisited");
    MetricProxy*metric=superGraph->getProperty<MetricProxy>("viewMetric");
    visited->setAllNodeValue(false);
    visited->setAllEdgeValue(false);
    selection->setAllNodeValue(false);
    selection->setAllEdgeValue(false);
    double initValue = metric->getNodeValue(tmpNode);
    double threshold = 1;
    list <node> bfsFifo;
    bool start=true;
    bfsFifo.push_back(tmpNode);
    while(!bfsFifo.empty()) {
      node itn = bfsFifo.front();
      bfsFifo.pop_front();
      selection->setNodeValue(itn,true);
      visited->setNodeValue(itn,true);
      Iterator<node> *itN = superGraph->getInOutNodes(itn);
      while (itN->hasNext()) {
	node itv = itN->next();
	double curValue = metric->getNodeValue(itv);
	if ( curValue == initValue && (!visited->getNodeValue(itv)) ) {
	  bfsFifo.push_back(itv);
	}
      } delete itN;
    }
    Observable::unholdObservers();
  }

  if (qMouseEv->button()==QEvent::MidButton){}
  if (qMouseEv->button()==QEvent::RightButton) {}
}

void MouseMagicSelection::mPaint(GlGraphWidget *glGraphWidget){}
void MouseMagicSelection:: mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){}
void MouseMagicSelection:: mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){}
