#ifndef CLUSTERTREE_H
#define CLUSTERTREE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>
#include <qpoint.h>

#include <tulip/tulipconf.h>
#include <tulip/MutableContainer.h>
#include "ClusterTreeData.h"

class SuperGraph;
class QListViewItem;
class QListView;
class QPopupMenu;
/** \addtogroup Tulip_Widgets */ 
/*@{*/
class TLP_QT_SIMPLE_SCOPE ClusterTree : public ClusterTreeData { 
  Q_OBJECT;
  
public:
  ClusterTree(SuperGraph *rootGraph, QWidget* parent = 0, const char* name = 0, Qt::WFlags fl = 0);
  ClusterTree(QWidget* parent = 0, const char *name = 0, Qt::WFlags fl = 0);
  SuperGraph *getSuperGraph() const;
  
public slots:
  void setSuperGraph(SuperGraph *);
  void update();

signals:
  void aboutToRemoveView(SuperGraph *);
  void aboutToRemoveAllView(SuperGraph *);
  void supergraphChanged(SuperGraph *);

private slots:
  void contextRemoveCluster();
  void contextRemoveAllCluster();
  void contextCloneSubgraphCluster();
  void contextMoveUpCluster();
  void contextRenameCluster();
  void contextCloneCluster();
  void currentGraphChanged(const SuperGraph *);
  void rightButtonClusterTree(QListViewItem *item, const QPoint &p, int c);
  void changeSuperGraph(QListViewItem *item,const QPoint &p, int i);
  void changeSuperGraph(QListViewItem *item);

 protected:
  void buildTreeView(QListView *item,SuperGraph *p);
  void buildTreeView(QListViewItem *item,SuperGraph *p);
  void removeSubgraph(SuperGraph *graph, bool recursive);

private:
  MutableContainer<QListViewItem *> graphItems;
  SuperGraph *_currentGraph;
};
/*@}*/
#endif // CLUSTERTREE_H
