//-*-c++-*-
#ifndef _CLUSTERING_H
#define _CLUSTERING_H

#include <list>
#include <string>
#include "SuperGraph.h"
#include "Reflect.h"
#include "WithParameter.h"
#include "PluginProgress.h"
#include "Plugin.h"
#include "TemplateFactory.h"

/**
 * \defgroup plugins
 */ 
/*@{*/
///Interface for clustering plug-ins
class Clustering : public WithParameter
{ 
public :
  Clustering (ClusterContext context):superGraph(context.superGraph),pluginProgress(context.pluginProgress),dataSet(context.dataSet){}
  virtual ~Clustering() {}
  virtual bool run() = 0;
  virtual bool check(std::string &) {return true;}
  virtual void reset() {}  

protected:
  SuperGraph *superGraph;
  PluginProgress *pluginProgress;
  DataSet *dataSet;
};

class ClusteringFactory:public Plugin{
public:
  static TLP_SCOPE TemplateFactory<ClusteringFactory,Clustering,ClusterContext > *factory;
  static void initFactory() {
    if (!factory) {
      factory = new TemplateFactory<ClusteringFactory,Clustering,ClusterContext >;
      factory->currentLoader = 0;
    }
  }
  virtual ~ClusteringFactory() {}
  virtual Clustering * createObject(ClusterContext)=0;
};
/*@}*/
#endif






