#include <iostream>

#if (QT_REL == 3)
#include <qcursor.h>
#else
#ifdef  _WIN32
// compilation pb workaround
#include <windows.h>
#endif
#include <QtGui/qcursor.h>
#include <QtGui/qevent.h>
#include "tulip/Qt3ForTulip.h"
#endif

#include "tulip/SuperGraph.h"
#include "tulip/MouseObject.h"
#include "tulip/GlGraphWidget.h"
#include "tulip/TulipElementProperties.h"

using namespace tlp;
// according to Qt's doc, this constant has been defined by wheel mouse vendors
// we need it to interpret the value of QWheelEvent->delta()
#define WHEEL_DELTA 120

//===============================================================
void MouseMove::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  if (qMouseEv->button()==Qt::LeftButton) {
    x=qMouseEv->x();
    y=qMouseEv->y();
  }
  if (qMouseEv->button()==Qt::MidButton) {}
}
void MouseMove::mPaint(GlGraphWidget *){}
void MouseMove::mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {}
void MouseMove::mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  if (qMouseEv->x()!=x) glGraphWidget->translateCamera(qMouseEv->x()-x,0,0);
  if (qMouseEv->y()!=y) glGraphWidget->translateCamera(0,y-qMouseEv->y(),0);
  x=qMouseEv->x();
  y=qMouseEv->y();
}
//===============================================================
void MouseRotXRotY::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){
  if (qMouseEv->button()==Qt::LeftButton) {
    y=qMouseEv->y();
    x=qMouseEv->x();
  }
  if (qMouseEv->button()==Qt::MidButton) {}
}
void MouseRotXRotY::mPaint(GlGraphWidget *){}
void MouseRotXRotY:: mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {}
void MouseRotXRotY:: mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  int deltaX,deltaY;
  deltaX=qMouseEv->x()-x;
  deltaY=qMouseEv->y()-y;
  if (abs(deltaX)>abs(deltaY)) 
    deltaY=0;
  else
    deltaX=0;  
  if (deltaY!=0) glGraphWidget->rotateScene(deltaY,0,0);
  if (deltaX!=0) glGraphWidget->rotateScene(0,deltaX,0);
  x=qMouseEv->x();
  y=qMouseEv->y();
}
//===============================================================
void MouseZoomRotZ::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){
  if (qMouseEv->button()==Qt::LeftButton) {
    y=qMouseEv->y();
    x=qMouseEv->x();
  }
  if (qMouseEv->button()==Qt::MidButton) {}
}
void MouseZoomRotZ::mPaint(GlGraphWidget *){}
void MouseZoomRotZ:: mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv)
{}
void MouseZoomRotZ:: mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  int deltaX,deltaY;
  deltaX=qMouseEv->x()-x;
  deltaY=qMouseEv->y()-y;
  if (abs(deltaX)>abs(deltaY)) 
    deltaY=0;
  else
    deltaX=0; 
  if (deltaX!=0) glGraphWidget->rotateScene(0,0,deltaX);
  if (deltaY!=0) glGraphWidget->zoom(-deltaY);
  x=qMouseEv->x();
  y=qMouseEv->y();
}
//===============================================================
// Fonstion de souris appartenant  l'application
//===============================================================
void MouseSelect::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){
  if (qMouseEv->button()==Qt::LeftButton) {
    glGraphWidget->clickAt(qMouseEv->pos());
  }
  if (qMouseEv->button()==Qt::MidButton){}
}
void MouseSelect::mPaint(GlGraphWidget *){}
void MouseSelect::mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){}
void MouseSelect::mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){}
//===============================================================
void MouseDel::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  if (qMouseEv->button()==Qt::LeftButton) {
    //    glGraphWidget->deleteElement(qMouseEv->x(),qMouseEv->y());
    bool result;
    ElementType type;
    node tmpNode;
    edge tmpEdge;
    result = glGraphWidget->doSelect(qMouseEv->x(), qMouseEv->y(), type, tmpNode, tmpEdge);
    if(result==true) {
      Observable::holdObservers();
      switch(type) {
      case NODE: glGraphWidget->getSuperGraph()->delNode(tmpNode); break;
      case EDGE: glGraphWidget->getSuperGraph()->delEdge(tmpEdge); break;
      }
      Observable::unholdObservers();
    }
  }
  if (qMouseEv->button()==Qt::MidButton)
    {}
  if (qMouseEv->button()==Qt::RightButton)
    {}
}
void MouseDel::mPaint(GlGraphWidget *){}
void MouseDel::mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv)
{}
void MouseDel::mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv)
{}
//===============================================================
MouseGraphNavigate::MouseGraphNavigate() : currentMouse(NULL){};
MouseGraphNavigate::~MouseGraphNavigate() {}

void MouseGraphNavigate::mPressEvent(GlGraphWidget *graph, QMouseEvent *e) {
  if (e->button() == Qt::LeftButton) {
    if (e->state() &
#if defined(__APPLE__)
	Qt::AltButton
#else
	Qt::ControlButton
#endif
	)
      currentMouse = &mouseZoomRotZ;
    else if (e->state() & Qt::ShiftButton)
      currentMouse = &mouseRotXRotY;
    else
      currentMouse = &mouseMove;
    
    currentMouse->mPressEvent(graph, e);
  }
  else {
    currentMouse = NULL;
    e->ignore();
  }
}

void MouseGraphNavigate::mReleaseEvent(GlGraphWidget *graph, QMouseEvent *e) {}

void MouseGraphNavigate::mMoveEvent(GlGraphWidget *graph, QMouseEvent *e) {
  if ((e->state() & Qt::LeftButton) && (currentMouse != NULL)) {
    currentMouse->mMoveEvent(graph, e);
  }
  else
    e->ignore();
}

void MouseGraphNavigate::mPaint(GlGraphWidget *) {}

void MouseGraphNavigate::keyPressEvent(GlGraphWidget *g, QKeyEvent *e) {
  int delta = (e->isAutoRepeat() ? 3 : 1);
  e->accept();
  switch(e->key()) {
    case Qt::Key_Left: g->translateCamera(delta * 2,0,0); break;
    case Qt::Key_Right: g->translateCamera(-1 * delta * 2,0,0); break;
    case Qt::Key_Up: g->translateCamera(0,-1 * delta * 2,0); break;
    case Qt::Key_Down: g->translateCamera(0,delta * 2,0); break;
    case Qt::Key_Prior: g->zoom(delta); break;
    case Qt::Key_Next: g->zoom(-1 * delta); break;
    case Qt::Key_Home: g->translateCamera(0,0,-1 * delta * 2); break;
    case Qt::Key_End: g->translateCamera(0,0,delta * 2); break;
    case Qt::Key_Insert: g->rotateScene(0,0,-1 * delta * 2); break;
    case Qt::Key_Delete : g->rotateScene(0,0,delta * 2); break;
    default:
      e->ignore();
    }
}
  
void MouseGraphNavigate::keyReleaseEvent(GlGraphWidget *g, QKeyEvent *e) {
  switch(e->key()) {
  case Qt::Key_Left:
  case Qt::Key_Right:
  case Qt::Key_Up:
  case Qt::Key_Down:
  case Qt::Key_Prior:
  case Qt::Key_Next:
  case Qt::Key_Home:
  case Qt::Key_End:
  case Qt::Key_Insert:
  case Qt::Key_Delete: break;
  default:
    e->ignore();
  }
}

void MouseGraphNavigate::wheelEvent(GlGraphWidget *g, QWheelEvent *e) {
  if (e->orientation() == Qt::Vertical) {
    g->zoomXY(e->delta() / WHEEL_DELTA, e->x(), e->y());
  }
  else {
    e->ignore();
  }
}

//================================================================================
using namespace std;
Mouse2D::Mouse2D() : currentMouse(NULL) {}

Mouse2D::~Mouse2D() {}

void Mouse2D::mPressEvent(GlGraphWidget *g, QMouseEvent *e) {
  if (e->button() == Qt::LeftButton) {
    if (e->state() & 
#if defined(__APPLE_)
	Qt::AltButton
#else
	Qt::ControlButton
#endif
	) 
      currentMouse = &mouseMove;
    else 
      currentMouse = &mouseSelect;
    currentMouse->mPressEvent(g, e);
  }
  else {
    currentMouse = NULL;
    e->ignore();
  }
}

void Mouse2D::mReleaseEvent(GlGraphWidget *g, QMouseEvent *e) {}

void Mouse2D::mMoveEvent(GlGraphWidget *g, QMouseEvent *e) {
  if ((e->state() & Qt::LeftButton) && (currentMouse != NULL)) {
    currentMouse->mMoveEvent(g, e);
  }
  else
    e->ignore();
}

void Mouse2D::mPaint(GlGraphWidget *g) {
  if (currentMouse != NULL) currentMouse->mPaint(g);
}

void Mouse2D::keyPressEvent (GlGraphWidget *g, QKeyEvent *e) {
  //  cerr << __PRETTY_FUNCTION__ << ": key=" << e->key() << ", state=" << e->state() << endl;
  if (e->key() & Qt::Key_Control) {
    oldCursor = QCursor(g->cursor());
    g->unsetCursor();
    g->setCursor(QCursor(Qt::SizeAllCursor));
  }

  int delta = (e->isAutoRepeat() ? 3 : 1);
  e->accept();
  switch(e->key()) {
    case Qt::Key_Left: g->translateCamera(delta * 2,0,0); break;
    case Qt::Key_Right: g->translateCamera(-1 * delta * 2,0,0); break;
    case Qt::Key_Up: g->translateCamera(0,-1 * delta * 2,0); break;
    case Qt::Key_Down: g->translateCamera(0,delta * 2,0); break;
    case Qt::Key_Prior: g->zoom(delta); break;
    case Qt::Key_Next: g->zoom(-1 * delta); break;
    case Qt::Key_Home: g->translateCamera(0,0,-1 * delta * 2); break;
    case Qt::Key_End: g->translateCamera(0,0,delta * 2); break;
    case Qt::Key_Insert: g->rotateScene(0,0,-1 * delta * 2); break;
    case Qt::Key_Delete : g->rotateScene(0,0,delta * 2); break;
    default:
      e->ignore();
    }


}
void Mouse2D::keyReleaseEvent(GlGraphWidget *g, QKeyEvent *e) {
  //  cerr << __PRETTY_FUNCTION__ << ": key=" << e->key() << ", state=" << e->state() << endl;  
  if (e->key() & Qt::Key_Control) {
    g->unsetCursor();
    g->setCursor(oldCursor);
  }
}

void Mouse2D::wheelEvent(GlGraphWidget *g, QWheelEvent *e) {
  if (e->orientation() == Qt::Vertical) {
    g->zoomXY(e->delta() / WHEEL_DELTA, e->x(), e->y());
  }
  else {
    e->ignore();
  }
}
