//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef GLAD_COMPOSITE_H
#define GLAD_COMPOSITE_H

#include "GlAugmentedDisplay.h"
#include <map>
#include <string>

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

namespace tlp {
  class TLP_GL_SCOPE GlADComposite : public GlAugmentedDisplay {

  
  public:
    GlADComposite();
    ~GlADComposite();

    void reset(bool deleteElems);
    void addGlAugmentedDisplay(GlAugmentedDisplay *augmentedDisplay, const string &key);
    void deleteGlAugmentedDisplay(const std::string &key);
    void deleteGlAugmentedDisplay(GlAugmentedDisplay *augmentedDisplay);
    std::string findKey(GlAugmentedDisplay *augmentedDisplay);
    GlAugmentedDisplay* findGlAugmentedDisplay(const string &key);
    inline stdext::hash_map<std::string, tlp::GlAugmentedDisplay*> *
      getDisplays () {
      return &elements;
    }

    void draw(GlGraph *graph);

    /**
     * Determines which elements of the rendering context have been picked
     * by the mouse.  Returns true if items are picked.
     * \param x the x coordinate of the mouse click
     * \param y the y coordinate of the mouse click
     * \param width the width of the selection window
     * \param height the height of the selection window
     * \param pickedAugmentedDisplays the augmented displays which have been
     * picked
     * \param glGraph the glGraph which picking is executed on.
     */
    bool doSelect(const int x, const int y,
		  const int width, const int height,
		  vector <pair <string, GlAugmentedDisplay *> >
		  &pickedAugmentedDisplays,
		  GlGraph *glGraph);

  private:
    /**
     * Function to give picking indexes to augmented displayes
     * \param glGraph the graph which contains these augmented displays.
     */
    void makeAugmentedDisplaySelect(GlGraph *glGraph,
				    int x, int y, 
				    const int w, const int h,
				    const tlp::Vector<int, 4> &viewport);

  protected:
    stdext::hash_map<string, GlAugmentedDisplay*> elements;
    std::list<GlAugmentedDisplay *> _sortedElements; //necessary to enable ordering of elements (for alpha blending)

  };
}
#endif
