//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tulip/LayoutProperty.h>
#include "tulip/GlGraph.h"
using namespace std;
namespace tlp {

  //===================================================================
  const GlGraphRenderingParameters& GlGraph::getRenderingParameters() {
    return _renderingParameters;
  }
  //===================================================================
  void GlGraph::setRenderingParameters(const GlGraphRenderingParameters &parameter) {
    if (_graph != 0) _graph->removeObserver(this);
    deleteIterators();
    bool alreadyInOrderedMode = _renderingParameters.isElementOrdered();

    _renderingParameters = parameter;

    if (_graph != _renderingParameters.getGraph()) { //the graph changed
      _graph = _renderingParameters.getGraph();
      if (_graph !=0 && _renderingParameters.isElementOrdered()) {
	buildOrderedList();
      }
    }
    else { //same graph
      if (_renderingParameters.isElementOrdered() != alreadyInOrderedMode) {
	buildOrderedList();
      }
    }
    if (_renderingParameters.isElementOrdered() && _graph!=0)
      _graph->addObserver(this);
  }
}
