//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
// Warning !!! this file does not have to be compiled
// when building Tulip with Qt 3
#include "tulip/GlGraphWidgetPlugin.h"
#include <QtCore/QtPlugin>
#include "tulip/GlGraphWidget.h"

#include "../designer/GlGraphWidget.xpm"

GlGraphWidgetPlugin::GlGraphWidgetPlugin(QObject *parent) : QObject(parent) {
  initialized = false;
}

void GlGraphWidgetPlugin::initialize(QDesignerFormEditorInterface * /*core*/) {
  if (initialized)
    return;

  initialized = true;
}

bool GlGraphWidgetPlugin::isInitialized() const {
  return initialized;
}

QWidget* GlGraphWidgetPlugin::createWidget(QWidget *parent) {
  return new GlGraphWidget(parent, name());
}

QString GlGraphWidgetPlugin::name() const {
  return "tlp::GlGraphWidget";
}
  
QString GlGraphWidgetPlugin::domXml() const {
  return "<widget class=\"GlGraphWidget\" name=\"glGraphWidget\">\n"
	 "</widget>\n";
}

QString GlGraphWidgetPlugin::includeFile() const {
  return "tulip/GlGraphWidget.h";
}

QString GlGraphWidgetPlugin::group() const {
  return "Tulip Widgets";
}

QIcon GlGraphWidgetPlugin::icon() const {
  return QIcon(QPixmap(GlGraphWidget_xpm));
}

QString GlGraphWidgetPlugin::toolTip() const {
  return "GlGraph Widget";
}

QString GlGraphWidgetPlugin::whatsThis() const {
  return "A widget displaying a Tulip GlGraph";
}

bool GlGraphWidgetPlugin::isContainer() const {
  return false;
}

QString GlGraphWidgetPlugin::codeTemplate() const {
    return "";
}

Q_EXPORT_PLUGIN(GlGraphWidgetPlugin)
