//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef TLP_PLUGINLOADER
#define TLP_PLUGINLOADER
#include <list>
#include <string>
#include <tulip/WithDependency.h>

namespace tlp {

struct PluginLoader {
  virtual ~PluginLoader(){}
  virtual void start(const std::string &path,const std::string &type)=0;
  virtual void numberOfFiles(int nbFiles) {}
  virtual void loading(const std::string &filename)=0;
  virtual void loaded(const std::string &name,
		      const std::string &author,
		      const std::string &date, 
		      const std::string &info,
		      const std::string &release,
		      const std::string &version,
		      const std::list <Dependency>&)=0;
  virtual void aborted(const std::string &filename,const  std::string &erreurmsg)=0;
  virtual void finished(bool state,const std::string &msg)=0;
};

}
#endif
