//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include "tulip/Graph.h"
#include "tulip/DoubleProperty.h"
#include "tulip/StringProperty.h"
#include "tulip/BooleanProperty.h"
#include "tulip/LayoutProperty.h"
#include "tulip/IntegerProperty.h"
#include "tulip/ColorProperty.h"
#include "tulip/SizeProperty.h"
#include "tulip/GraphProperty.h"

std::string tlp::PropertyInterface::getTypename( tlp::PropertyInterface * propertyName ) {
  if (typeid((*propertyName)) == typeid(tlp::GraphProperty)) return "graph";
  if (typeid((*propertyName)) == typeid(tlp::DoubleProperty)) return "double";
  if (typeid((*propertyName)) == typeid(tlp::LayoutProperty)) return "layout";
  if (typeid((*propertyName)) == typeid(tlp::StringProperty)) return "string";
  if (typeid((*propertyName)) == typeid(tlp::IntegerProperty)) return "int";
  if (typeid((*propertyName)) == typeid(tlp::ColorProperty)) return "color";
  if (typeid((*propertyName)) == typeid(tlp::SizeProperty)) return "size";
  if (typeid((*propertyName)) == typeid(tlp::BooleanProperty)) return "bool";
  return "unknown";
}
