//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cassert>
#include <iostream>
#include "tulip/GlSceneObserver.h"

using namespace std;

namespace tlp {

  void GlObservableScene::notifyAddLayer(GlScene *scene, const string& name, GlLayer* layer) {
    set<GlSceneObserver *> copy(observers); //Used to preserve iteratros
    for (set<GlSceneObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
      (*itlObs)->addLayer(scene, name, layer);
  }

  void GlObservableScene::notifyDelLayer(GlScene *scene, const string& name, GlLayer* layer) {
    set<GlSceneObserver *> copy(observers); //Used to preserve iteratros
    for (set<GlSceneObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
      (*itlObs)->delLayer(scene, name, layer);
  }

  void GlObservableScene::notifyModifyLayer(GlScene *scene, const string& name, GlLayer* layer) {
    set<GlSceneObserver *> copy(observers); //Used to preserve iteratros
    for (set<GlSceneObserver *>::iterator itlObs=copy.begin();itlObs!=copy.end();++itlObs)
      (*itlObs)->modifyLayer(scene, name, layer);
  }
}

