#Boa:Dialog:preferences
#TunaPie (c)2005-2006 James Stone. Released under the GNU GPL.
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#
#Written using Boa-Constructor.
#http://boa-constructor.sourceforge.net/
#
#Version 0.4.8 15/11/06

import wxversion
wxversion.select("2.6")
import wx
import wx.lib.masked.numctrl
import wx.lib.stattext
import tuner

def create(parent):
    return preferences(parent)

[wxID_PREFERENCES, wxID_PREFERENCESAUDIOBROWSE, wxID_PREFERENCESAUDIOPATH, 
 wxID_PREFERENCESBUTTON1, wxID_PREFERENCESBUTTON2, wxID_PREFERENCESFONTSLIDE, 
 wxID_PREFERENCESGENSTATICTEXT1, wxID_PREFERENCESGENSTATICTEXT2, 
 wxID_PREFERENCESGENSTATICTEXT3, wxID_PREFERENCESGENSTATICTEXT4, 
 wxID_PREFERENCESGENSTATICTEXT5, wxID_PREFERENCESGENSTATICTEXT6, 
 wxID_PREFERENCESGENSTATICTEXT7, wxID_PREFERENCESICECASTBUTTON, 
 wxID_PREFERENCESMAXDISP, wxID_PREFERENCESRIPDIR, 
 wxID_PREFERENCESRIPDIRBROWSE, wxID_PREFERENCESRIPPATH, 
 wxID_PREFERENCESSERVERTEXT, wxID_PREFERENCESSHOUTCASTBUTTON, 
 wxID_PREFERENCESSTREAMRIPBROWSE, wxID_PREFERENCESTERMPATH, 
 wxID_PREFERENCESTEXTCTRL1, wxID_PREFERENCESVIDEOBROWSE, 
 wxID_PREFERENCESVIDEOPATH, wxID_PREFERENCESXTERMBROWSE, 
] = [wx.NewId() for _init_ctrls in range(26)]

class preferences(wx.Dialog):
    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Dialog.__init__(self, id=wxID_PREFERENCES, name='preferences',
              parent=prnt, pos=wx.Point(289, 197), size=wx.Size(451, 321),
              style=wx.DEFAULT_DIALOG_STYLE, title='Preferences')
        self.SetClientSize(wx.Size(451, 321))
        self.SetBackgroundColour(wx.Colour(222, 223, 206))
        self.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.SetThemeEnabled(True)

        self.genStaticText1 = wx.lib.stattext.GenStaticText(ID=wxID_PREFERENCESGENSTATICTEXT1,
              label='Full path to audio player:', name='genStaticText1',
              parent=self, pos=wx.Point(8, 16), size=wx.Size(137, 13), style=0)
        self.genStaticText1.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText1.SetBackgroundColour(wx.Colour(222, 223, 206))
        self.genStaticText1.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText1.SetThemeEnabled(True)

        self.genStaticText2 = wx.lib.stattext.GenStaticText(ID=wxID_PREFERENCESGENSTATICTEXT2,
              label=u'Full path to nsv player:', name='genStaticText2',
              parent=self, pos=wx.Point(8, 48), size=wx.Size(126, 13), style=0)
        self.genStaticText2.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText2.SetBackgroundColour(wx.Colour(222, 223, 206))
        self.genStaticText2.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText2.SetThemeEnabled(True)

        self.button1 = wx.Button(id=wxID_PREFERENCESBUTTON1, label='Save',
              name='button1', parent=self, pos=wx.Point(290, 280),
              size=wx.Size(80, 24), style=0)
        self.button1.SetDefault()
        self.button1.SetFont(wx.Font(7, 77, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.button1.SetThemeEnabled(True)
        self.button1.Bind(wx.EVT_BUTTON, self.OnButton1Button,
              id=wxID_PREFERENCESBUTTON1)

        self.button2 = wx.Button(id=wxID_PREFERENCESBUTTON2, label='Cancel',
              name='button2', parent=self, pos=wx.Point(80, 280),
              size=wx.Size(80, 24), style=0)
        self.button2.SetFont(wx.Font(7, 77, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.button2.SetThemeEnabled(True)
        self.button2.Bind(wx.EVT_BUTTON, self.OnButton2Button,
              id=wxID_PREFERENCESBUTTON2)

        self.audiopath = wx.TextCtrl(id=wxID_PREFERENCESAUDIOPATH,
              name='audiopath', parent=self, pos=wx.Point(168, 16),
              size=wx.Size(200, 22), style=0, value='/usr/bin/xmms')
        self.audiopath.SetFont(wx.Font(7, 77, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.audiopath.SetBackgroundColour(wx.Colour(255, 253, 239))
        self.audiopath.SetThemeEnabled(True)
        self.audiopath.SetBestFittingSize(wx.Size(200, 22))

        self.videopath = wx.TextCtrl(id=wxID_PREFERENCESVIDEOPATH,
              name='videopath', parent=self, pos=wx.Point(168, 48),
              size=wx.Size(200, 22), style=0, value='/usr/bin/mplayer')
        self.videopath.SetFont(wx.Font(7, 77, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.videopath.SetBackgroundColour(wx.Colour(255, 253, 239))
        self.videopath.SetThemeEnabled(True)
        self.videopath.SetBestFittingSize(wx.Size(200, 22))

        self.genStaticText3 = wx.lib.stattext.GenStaticText(ID=wxID_PREFERENCESGENSTATICTEXT3,
              label='Full path to x-terminal:', name='genStaticText3',
              parent=self, pos=wx.Point(8, 80), size=wx.Size(125, 13), style=0)
        self.genStaticText3.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText3.SetBackgroundColour(wx.Colour(222, 223, 206))
        self.genStaticText3.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText3.SetThemeEnabled(True)

        self.genStaticText4 = wx.lib.stattext.GenStaticText(ID=wxID_PREFERENCESGENSTATICTEXT4,
              label='Full path to streamripper:', name='genStaticText4',
              parent=self, pos=wx.Point(8, 112), size=wx.Size(143, 13),
              style=0)
        self.genStaticText4.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText4.SetBackgroundColour(wx.Colour(222, 223, 206))
        self.genStaticText4.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText4.SetThemeEnabled(True)

        self.termpath = wx.TextCtrl(id=wxID_PREFERENCESTERMPATH,
              name='termpath', parent=self, pos=wx.Point(168, 80),
              size=wx.Size(200, 22), style=0,
              value='/usr/bin/x-terminal-emulator')
        self.termpath.SetFont(wx.Font(7, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.termpath.SetBackgroundColour(wx.Colour(255, 253, 239))
        self.termpath.SetThemeEnabled(True)
        self.termpath.SetBestFittingSize(wx.Size(200, 22))

        self.rippath = wx.TextCtrl(id=wxID_PREFERENCESRIPPATH, name='rippath',
              parent=self, pos=wx.Point(168, 112), size=wx.Size(200, 22),
              style=0, value='/usr/bin/streamripper')
        self.rippath.SetFont(wx.Font(7, 77, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.rippath.SetBackgroundColour(wx.Colour(255, 253, 239))
        self.rippath.SetThemeEnabled(True)
        self.rippath.SetBestFittingSize(wx.Size(200, 22))

        self.genStaticText5 = wx.lib.stattext.GenStaticText(ID=wxID_PREFERENCESGENSTATICTEXT5,
              label=u'Full path to rip directory:', name='genStaticText5',
              parent=self, pos=wx.Point(8, 144), size=wx.Size(136, 13),
              style=0)
        self.genStaticText5.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText5.SetBackgroundColour(wx.Colour(222, 223, 206))
        self.genStaticText5.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.genStaticText5.SetThemeEnabled(True)

        self.ripdir = wx.TextCtrl(id=wxID_PREFERENCESRIPDIR, name=u'ripdir',
              parent=self, pos=wx.Point(168, 144), size=wx.Size(200, 22),
              style=0, value=u'~/.tunapie/streamripper')
        self.ripdir.SetBackgroundColour(wx.Colour(255, 253, 239))
        self.ripdir.SetFont(wx.Font(7, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.ripdir.SetThemeEnabled(True)
        self.ripdir.SetBestFittingSize(wx.Size(200, 22))

        self.servertext = wx.lib.stattext.GenStaticText(ID=wxID_PREFERENCESSERVERTEXT,
              label=u'Server:', name=u'servertext', parent=self,
              pos=wx.Point(80, 245), size=wx.Size(42, 13), style=0)
        self.servertext.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.servertext.SetBackgroundColour(wx.Colour(222, 223, 206))
        self.servertext.SetThemeEnabled(True)
        self.servertext.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)

        self.icecastbutton = wx.RadioButton(id=wxID_PREFERENCESICECASTBUTTON,
              label=u'Icecast', name=u'icecastbutton', parent=self,
              pos=wx.Point(160, 245), size=wx.Size(96, 21), style=0)
        self.icecastbutton.SetValue(True)
        self.icecastbutton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.icecastbutton.SetThemeEnabled(True)

        self.shoutcastbutton = wx.RadioButton(id=wxID_PREFERENCESSHOUTCASTBUTTON,
              label=u'Shoutcast', name=u'shoutcastbutton', parent=self,
              pos=wx.Point(272, 245), size=wx.Size(96, 21), style=0)
        self.shoutcastbutton.SetValue(False)
        self.shoutcastbutton.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.shoutcastbutton.SetThemeEnabled(True)

        self.audiobrowse = wx.Button(id=wxID_PREFERENCESAUDIOBROWSE,
              label=u'Browse', name=u'audiobrowse', parent=self,
              pos=wx.Point(380, 16), size=wx.Size(53, 22), style=0)
        self.audiobrowse.SetFont(wx.Font(7, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.audiobrowse.SetThemeEnabled(True)
        self.audiobrowse.Bind(wx.EVT_BUTTON, self.OnAudiobrowseButton,
              id=wxID_PREFERENCESAUDIOBROWSE)

        self.videobrowse = wx.Button(id=wxID_PREFERENCESVIDEOBROWSE,
              label=u'Browse', name=u'videobrowse', parent=self,
              pos=wx.Point(380, 48), size=wx.Size(53, 22), style=0)
        self.videobrowse.SetFont(wx.Font(7, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.videobrowse.Bind(wx.EVT_BUTTON, self.OnVideobrowseButton,
              id=wxID_PREFERENCESVIDEOBROWSE)

        self.xtermbrowse = wx.Button(id=wxID_PREFERENCESXTERMBROWSE,
              label=u'Browse', name=u'xtermbrowse', parent=self,
              pos=wx.Point(380, 80), size=wx.Size(53, 22), style=0)
        self.xtermbrowse.SetFont(wx.Font(7, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.xtermbrowse.SetThemeEnabled(True)
        self.xtermbrowse.Bind(wx.EVT_BUTTON, self.OnXtermbrowseButton,
              id=wxID_PREFERENCESXTERMBROWSE)

        self.streamripbrowse = wx.Button(id=wxID_PREFERENCESSTREAMRIPBROWSE,
              label=u'Browse', name=u'streamripbrowse', parent=self,
              pos=wx.Point(380, 112), size=wx.Size(53, 22), style=0)
        self.streamripbrowse.SetFont(wx.Font(7, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.streamripbrowse.SetThemeEnabled(True)
        self.streamripbrowse.Bind(wx.EVT_BUTTON, self.OnStreamripbrowseButton,
              id=wxID_PREFERENCESSTREAMRIPBROWSE)

        self.ripdirbrowse = wx.Button(id=wxID_PREFERENCESRIPDIRBROWSE,
              label=u'Browse', name=u'ripdirbrowse', parent=self,
              pos=wx.Point(380, 144), size=wx.Size(53, 22), style=0)
        self.ripdirbrowse.SetFont(wx.Font(7, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.ripdirbrowse.SetThemeEnabled(True)
        self.ripdirbrowse.Bind(wx.EVT_BUTTON, self.OnRipdirbrowseButton,
              id=wxID_PREFERENCESRIPDIRBROWSE)

        self.genStaticText6 = wx.lib.stattext.GenStaticText(ID=wxID_PREFERENCESGENSTATICTEXT6,
              label=u'Max. streams to display in main list (50-500):',
              name='genStaticText6', parent=self, pos=wx.Point(40, 176),
              size=wx.Size(252, 13), style=0)
        self.genStaticText6.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))

        self.maxdisp = wx.TextCtrl(id=wxID_PREFERENCESMAXDISP, name=u'maxdisp',
              parent=self, pos=wx.Point(328, 176), size=wx.Size(40, 22),
              style=0, value=u'100')
        self.maxdisp.SetThemeEnabled(True)
        self.maxdisp.SetBackgroundColour(wx.Colour(255, 253, 239))
        self.maxdisp.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.maxdisp.SetBestFittingSize(wx.Size(40, 22))

        self.genStaticText7 = wx.lib.stattext.GenStaticText(ID=wxID_PREFERENCESGENSTATICTEXT7,
              label=u'Default font size:', name='genStaticText7', parent=self,
              pos=wx.Point(56, 208), size=wx.Size(94, 13), style=0)
        self.genStaticText7.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText7.SetThemeEnabled(True)

        self.fontslide = wx.Slider(id=wxID_PREFERENCESFONTSLIDE, maxValue=12,
              minValue=5, name=u'fontslide', parent=self, point=wx.Point(176,
              208), size=wx.Size(140, 20), style=wx.SL_HORIZONTAL, value=8)
        self.fontslide.SetThemeEnabled(True)
        self.fontslide.SetMin(5)
        self.fontslide.SetMax(12)
        self.fontslide.SetBestFittingSize(wx.Size(140, 20))
        self.fontslide.SetLabel(u'')
        self.fontslide.SetPageSize(2)
        self.fontslide.Bind(wx.EVT_SCROLL, self.OnFontslideScroll)

        self.textCtrl1 = wx.TextCtrl(id=wxID_PREFERENCESTEXTCTRL1,
              name='textCtrl1', parent=self, pos=wx.Point(336, 208),
              size=wx.Size(32, 24), style=0, value=u'8')
        self.textCtrl1.SetBackgroundColour(wx.Colour(255, 253, 239))
        self.textCtrl1.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.textCtrl1.SetEditable(False)
        self.textCtrl1.SetThemeEnabled(True)
        self.textCtrl1.Enable(True)

    def __init__(self, parent):
        self._init_ctrls(parent)

    def setfontsize(self, newsize):
        size=int(newsize)
        self.genStaticText1.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText2.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.button1.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.button2.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.audiopath.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.videopath.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genStaticText3.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText4.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.termpath.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.rippath.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genStaticText5.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.ripdir.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.servertext.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.icecastbutton.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.shoutcastbutton.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.audiobrowse.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.videobrowse.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.xtermbrowse.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.streamripbrowse.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.genStaticText6.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.ripdirbrowse.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.maxdisp.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genStaticText7.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Sans'))
        self.textCtrl1.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
            
    
    def setvars(self,media,video,term,rip,home,rdir,shoutice,maxd,fontsize):
        self.audiopath.SetValue(media)
        self.videopath.SetValue(video)
        self.termpath.SetValue(term)
        self.rippath.SetValue(rip)
        self.ripdir.SetValue(rdir)
        self.shoutcastbutton.SetValue(bool(int(shoutice)))
        self.maxdisp.SetValue(str(int(maxd)))
        self.fontslide.SetValue(int(fontsize))
        self.textCtrl1.SetValue(str(int(fontsize)))
        self.home=home

    def OnButton2Button(self, event):
        self.Close()

    def OnButton1Button(self, event):
        try:
            if (int(self.maxdisp.GetValue())<50):
                self.maxdisp.SetValue('50')
        except ValueError:
            self.maxdisp.SetValue('100')
        if (int(self.maxdisp.GetValue())>500):
            self.maxdisp.SetValue('500')
        tuner.writeprefs(self.home,self.audiopath.GetValue(),\
            self.videopath.GetValue(),self.termpath.GetValue(),\
            self.rippath.GetValue(), self.ripdir.GetValue(),\
            self.shoutcastbutton.GetValue(), self.maxdisp.GetValue(),\
            self.fontslide.GetValue())
        self.Close()

    def OnAudiobrowseButton(self, event):
        dlg = wx.FileDialog(self, "Choose a file", "/usr/bin", "", "*", wx.OPEN)
        try:
            if dlg.ShowModal() == wx.ID_OK:
                filename = dlg.GetPath()
                self.audiopath.SetValue(filename)
        finally:
            dlg.Destroy()
        

    def OnVideobrowseButton(self, event):
        dlg = wx.FileDialog(self, "Choose a file", "/usr/bin", "", "*", wx.OPEN)
        try:
            if dlg.ShowModal() == wx.ID_OK:
                filename = dlg.GetPath()
                self.videopath.SetValue(filename)
        finally:
            dlg.Destroy()

    def OnXtermbrowseButton(self, event):
        dlg = wx.FileDialog(self, "Choose a file", "/usr/bin", "", "*", wx.OPEN)
        try:
            if dlg.ShowModal() == wx.ID_OK:
                filename = dlg.GetPath()
                self.termpath.SetValue(filename)
        finally:
            dlg.Destroy()
        

    def OnStreamripbrowseButton(self, event):
        dlg = wx.FileDialog(self, "Choose a file", "/usr/bin", "", "*", wx.OPEN)
        try:
            if dlg.ShowModal() == wx.ID_OK:
                filename = dlg.GetPath()
                self.rippath.SetValue(filename)
        finally:
            dlg.Destroy()
        

    def OnRipdirbrowseButton(self, event):
        dlg = wx.DirDialog(self, "Choose a directory", self.home)
        try:
            if dlg.ShowModal() == wx.ID_OK:
                dir = dlg.GetPath()
                self.ripdir.SetValue(dir)
        finally:
            dlg.Destroy()

    def OnFontslideScroll(self, event):
        size=str(self.fontslide.GetValue())
        self.textCtrl1.SetValue(size)
        self.setfontsize(size)
        
        
