#Boa:Dialog:Search
#TunaPie (c)2005-2007 James Stone. Released under the GNU GPL.
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#
#Written using Boa-Constructor.
#http://boa-constructor.sourceforge.net/
#
#Version 2.0.0 21/4/07

import wx
import tunapie2_main

def create(parent):
    return Search(parent)

[wxID_SEARCH, wxID_SEARCHCANCELBUTTON, wxID_SEARCHSEARCHBUTTON, 
 wxID_SEARCHSEARCHTEXT, 
] = [wx.NewId() for _init_ctrls in range(4)]

class Search(wx.Dialog):
    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Dialog.__init__(self, id=wxID_SEARCH, name=u'Search', parent=prnt,
              pos=wx.Point(308, 321), size=wx.Size(443, 102),
              style=wx.DEFAULT_DIALOG_STYLE, title=u'Search')
        self.SetClientSize(wx.Size(443, 102))
        self.SetThemeEnabled(True)
        self.SetAutoLayout(True)

        self.searchtext = wx.TextCtrl(id=wxID_SEARCHSEARCHTEXT,
              name=u'searchtext', parent=self, pos=wx.Point(24, 16),
              size=wx.Size(400, 25), style=0, value=u'')
        self.searchtext.SetAutoLayout(True)
        self.searchtext.SetThemeEnabled(True)

        self.cancelbutton = wx.Button(id=wxID_SEARCHCANCELBUTTON,
              label=u'Cancel', name=u'cancelbutton', parent=self,
              pos=wx.Point(64, 56), size=wx.Size(85, 30), style=0)
        self.cancelbutton.SetAutoLayout(True)
        self.cancelbutton.SetThemeEnabled(True)
        self.cancelbutton.Bind(wx.EVT_BUTTON, self.OnCancelbuttonButton,
              id=wxID_SEARCHCANCELBUTTON)

        self.searchbutton = wx.Button(id=wxID_SEARCHSEARCHBUTTON,
              label=u'Search', name=u'searchbutton', parent=self,
              pos=wx.Point(296, 56), size=wx.Size(80, 30), style=0)
        self.searchbutton.SetAutoLayout(True)
        self.searchbutton.SetThemeEnabled(True)
        self.searchbutton.SetDefault()
        self.searchbutton.Bind(wx.EVT_BUTTON, self.OnSearchbuttonButton,
              id=wxID_SEARCHSEARCHBUTTON)

    def __init__(self, parent):
        self._init_ctrls(parent)
    
    def setfontsize(self,size):
        self.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,u'Sans'))
        self.cancelbutton.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,u'Sans'))
        self.searchbutton.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,u'Sans'))
        self.searchtext.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,u'Sans')) 

    def OnCancelbuttonButton(self, event):
        self.Close()

    def OnSearchbuttonButton(self, event):
        tunapie2_main.searchname=self.searchtext.GetLineText(0)
        self.Close()
