<?php
/**
 * Turba base inclusion file.
 *
 * $Horde: turba/lib/base.php,v 1.62.10.12 2006/03/01 19:31:46 chuck Exp $
 *
 * This file brings in all of the dependencies that every Turba script
 * will need, and sets up objects that all scripts use.
 */

// Check for a prior definition of HORDE_BASE (perhaps by an
// auto_prepend_file definition for site customization).
if (!defined('HORDE_BASE')) {
    @define('HORDE_BASE', dirname(__FILE__) . '/../..');
}

// Load the Horde Framework core, and set up inclusion paths.
require_once HORDE_BASE . '/lib/core.php';

// Registry.
$registry = &Registry::singleton();
if (is_a(($pushed = $registry->pushApp('turba', !defined('AUTH_HANDLER'))), 'PEAR_Error')) {
    if ($pushed->getCode() == 'permission_denied') {
        Horde::authenticationFailureRedirect();
    }
    Horde::fatal($pushed, __FILE__, __LINE__, false);
}
$conf = $GLOBALS['conf'];
@define('TURBA_TEMPLATES', $registry->get('templates'));

// Horde framework libraries.
require_once 'Horde/Help.php';
require_once 'Horde/History.php';

// Notification system.
$notification = &Notification::singleton();
$notification->attach('status');

// Find the base file path of Turba.
@define('TURBA_BASE', dirname(__FILE__) . '/..');

// Turba base library.
require_once TURBA_BASE . '/lib/Turba.php';
require_once TURBA_BASE . '/lib/Driver.php';

// Turba source and attribute configuration.
require TURBA_BASE . '/config/attributes.php';
require TURBA_BASE . '/config/sources.php';

// Turba's Horde_Share object.
require_once 'Horde/Share.php';
$GLOBALS['turba_shares'] = &Horde_Share::singleton($registry->getApp());

// See if any of our sources are configured to use Horde_Share.
$haveShare = false;
foreach ($cfgSources as $key => $cfg) {
    if (!empty($cfg['use_shares'])) {
        $haveShare = true;
    }
}
if ($haveShare) {
    $GLOBALS['cfgSources'] = Turba::getConfigFromShares($cfgSources);
} else {
    $GLOBALS['cfgSources'] = $cfgSources;
}
$GLOBALS['cfgSources'] = Turba::permissionsFilter($GLOBALS['cfgSources'], 'source');
$GLOBALS['attributes'] = $attributes;

// Build the directory sources select widget.
if (!isset($source)) {
    $source = Util::getFormData('source', Turba::getDefaultAddressBook());
}
$browse_source_options = '';
$browse_source_count = 0;
foreach (Turba::getAddressBooks() as $key => $curSource) {
    if (!empty($curSource['browse'])) {
        $selected = ($key == $source) ? ' selected="selected"' : '';
        $browse_source_options .= '<option value="' . htmlspecialchars($key) . '" ' . $selected . '>' .
            htmlspecialchars($curSource['title']) . '</option>';

        $browse_source_count++;

        if (empty($source)) {
            $source = $key;
        }
    }
}

// Hide the list of addressbooks if there is only one available.
$add_source_options = '';
$addSources = Turba::getAddressBooks(PERMS_EDIT);
if (count($addSources) > 1) {
    foreach ($addSources as $key => $curSource) {
        if ($key != $source) {
            $add_source_options .= '<option value="' . htmlspecialchars($key) . '">' .
                htmlspecialchars($curSource['title']) . '</option>';
        }
    }
}

// Start compression, if requested.
Horde::compressOutput();
