<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup bug
 * @module bug_new
 * @package bug
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'bug.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("bug","new");
 loadlayout();

 /**
  * change/modify a bug
  */
 class bug_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang,$tutos,$table;

     echo "<form name=\"bugnew\" action=\"bug_ins.php\" method=\"post\">\n";
     if ( $this->obj->id > 0 ) {
       $this->addHidden("id",$this->obj->id);
     } else {
       # state initially fixed to open
       $this->addHidden("state",$this->obj->state);
     }

     if ( ($tutos[bugautoname] != "") && ( $this->obj->id < 1) ) {
       $this->addHidden("name","auto");
     }

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">".  sprintf($lang['Showing'],$lang[$this->obj->getType()])."</th>\n";
     echo "</tr>\n";

     if ($this->obj->id > 0 ) {
       echo "<tr>\n";
       echo " <td colspan=\"3\">". sprintf ($lang['BugCreation'],$this->obj->creator->getLink(),$this->obj->creation->getDateTime()) ."</td>\n";
       echo " <td align=\"right\">". acl_link($this->obj) ."</td>\n";
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo $this->showfieldc($lang['BugID'],1,"name");
     echo " <td colspan=\"3\">";
     if ( $tutos[bugautoname] == "" ) {
       # name if totally free
       echo " <input id=\"name\" value=\"". $this->obj->name ."\" name=\"name\">\n";
     } else {
       # Using the autoname system for bugs
       if ( $this->obj->id > 0 ) {
         echo $this->obj->getLink();
         $this->addHidden("name",$this->obj->name);
       } else {
         $tmp = strftime($tutos[bugautoname]);
         echo $lang['BugAutoID'] ." ". $tmp;
       }
     }
     echo "</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['BugState'],0,"state");
     if ( $this->obj->id > 0 ) {
       echo " <td>". $this->obj->askState() ."</td>\n";
     } else {
       echo " <td>". $lang['BugAutoState'] ." ". $this->obj->getState() ."</td>\n";
     }
     echo $this->showfieldc($lang['BugClass'],0,"class");
     echo " <td>". $this->obj->askClass() ."</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['BugShort'],1,"short");
     echo " <td colspan=\"3\" valign=\"top\"><input id=\"short\" size=\"". min(40,$table['bug']['short'][size]) ."\" maxlength=\"". $table['bug']['short'][size] ."\" name=\"short\" value=\"". $this->obj->short ."\"></td>";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['BugAssignedTo']);
     echo " <td colspan=\"3\" valign=\"top\">";
     if ( $this->obj->id > 0 ) {
       select_from_array_or_input($this->obj,"s",$this->obj->solver,1);
     } else {
       $sid =  $this->user->id;
       # initial
       echo $lang['BugAutoSolver'] ."&nbsp;";
       if ( $this->obj->parent->id > 0 ) {
         if ( $this->obj->parent->getType() == "product" ) {
           $this->obj->parent->readroles();
           reset($this->obj->parent->role[PROD_ROLE_MANAGER]);
           reset($this->obj->parent->role[PROD_ROLE_MANAGER2]);
           if ( count($this->obj->parent->role[PROD_ROLE_MANAGER]) > 0 ) {
             $obj = current($this->obj->parent->role[PROD_ROLE_MANAGER]);
             echo $obj->getLink();
             $sid =  $obj->id;
           } else if ( count($this->obj->parent->role[PROD_ROLE_MANAGER2]) > 0)  {
             $obj = current($this->obj->parent->role[PROD_ROLE_MANAGER2]);
             echo $obj->getLink();
             $sid =  $obj->id;
           } else {
             echo  $this->user->getLink();
           }
         } else if ( $this->obj->parent->getType() == "installation" ) {
           $this->obj->parent->product->readroles();
           reset($this->obj->parent->product->role[PROD_ROLE_MANAGER]);
           reset($this->obj->parent->product->role[PROD_ROLE_MANAGER2]);
           if ( count($this->obj->parent->product->role[PROD_ROLE_MANAGER]) > 0 ) {
             $obj = current($this->obj->parent->product->role[PROD_ROLE_MANAGER]);
             echo $obj->getLink();
             $sid =  $obj->id;
           } else if ( count($this->obj->parent->product->role[PROD_ROLE_MANAGER2]) > 0)  {
             $obj = current($this->obj->parent->product->role[PROD_ROLE_MANAGER2]);
             echo $obj->getLink();
             $sid =  $obj->id;
           } else {
             echo $this->user->getLink();
           }
         } else if ( $this->obj->parent->getType() == "task" ) {
           foreach ($this->obj->parent->worker as $i => $f) {
             echo $this->obj->parent->worker[$i]->getLink();
             $sid =  $this->obj->parent->worker[$i]->id;
             break;
           }
         } else {
           echo $this->user->getLink();
         }
         $this->addHidden("sid",$sid);
       } else {
         echo $lang['Product'] ." ". $lang['ProdRole'][1];
       }
     }
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['BugReference'],1,"pid");
     echo " <td colspan=\"3\" valign=\"top\">\n";
     echo "<select id=\"pid\" name=\"pid\">\n";
     foreach ($this->obj->plist as $i => $f) {
       echo "<option value=\"". $i ."\"". ($i == $this->obj->parent->id ? " selected>* ":">") . $lang[$f->getType()] .": ". $f->getFullName() ."</option>\n";
     }
     echo "</select>\n";
     echo "</td></tr>\n";

     echo "<tr>\n";
     if ( $this->obj->id > 0 ) {
       echo $this->showfield($lang['BugHistory']);
       echo "<td colspan=\"3\" valign=\"top\" class=\"pre\"><pre>". wordwrap(urlReplace($this->obj->description,0),80);
       echo "</pre></td>\n";
       echo "</tr>\n";
       echo "<tr>\n";
       echo $this->showfield($lang['BugAdditional'],0,"description");
     } else {
       echo $this->showfield($lang['BugLong'],1,"description");
     }
     echo " <td colspan=\"3\" valign=\"top\"><textarea id=\"description\" rows=\"10\" cols=\"80\" name=\"description\">". $this->obj->newdesc;
     echo "</textarea></td>\n";
     echo "</tr>\n";

     # References to modules
     module_addforms($this->user,$this->obj,4);

     if ( $this->obj->mod_ok() != 0 ) {
       echo "<tr>\n";
       if ($this->obj->id > 0 ) {
         submit_reset(0,1,1,1,1,0);
       } else {
         submit_reset(0,-1,1,1,1,0);
       }
       echo "</tr>\n";
     }
     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("bugnew.short");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $tutos,$lang,$msg;

     $this->obj = new bug($this->dbconn);

     $this->obj->newdesc = "";

     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       if ($this->obj->id < 0) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
       $this->name = sprintf($lang['BugModifyI'],$this->obj->getFullName());
     } else {
       $this->name = $lang['BugCreate'];
     }

     if ( isset($_GET['description']) ) {
       $this->obj->newdesc = StripSlashes($_GET['description']);
     }
     if ( isset($_GET['short']) ) {
       $this->obj->short = StripSlashes($_GET['short']);
     }
     if ( isset($_GET['state']) ) {
       $this->obj->state = $_GET['state'];
     }
     if ( isset($_GET['class']) ) {
       $this->obj->class = $_GET['class'];
     }
     if ( isset($_GET['pid']) ) {
       $this->obj->parent = getObject($this->dbconn,$_GET['pid']);
     }
     # Get possible references
     $this->obj->read_relations();

     # Get the solver
     preset_from_array_or_input($this->obj,'solver',"s");

     if ( $this->obj->id < 0 ) {
       if ( !$this->user->feature_ok(usebugtracking,PERM_NEW) ) {
         $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     } else {
       if (! $this->obj->mod_ok() ) {
         $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     }
     # menu stuff
     $x = bug::getSelectLink($this->user,$lang['Search']);
	 $x[category][] = "obj";
     $this->addmenu($x);
     if ( $this->user->feature_ok(usebugtracking,PERM_NEW) ) {
       $x = array( url => "bug_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['CreateNewBug'],
                   category => array("bug","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "bug_del.php?id=".$this->obj->id,
                   text => $lang['Delete'],
                   confirm => true,
                   info => sprintf($lang['BugDeleteI'],$this->obj->getFullname()),
                   category => array("bug","del","obj")
                 );
       $this->addMenu($x);
     }

     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new bug_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: bug_new.php,v 1.57.2.7 2003/10/08 15:03:07 gokohnert Exp $
    $Author: gokohnert $
-->
