<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup company
 * @module company_del
 * @package company
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'appointment.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("company","del");

 $msg = "";
 $c = new company($dbconn);

 if ( !isset($_GET['id']) ) {
   $msg .= "Could not delete company<br>";
 } else {
   $c->read($_GET['id']);
 }

 if ( ! $c->del_ok() ) {
   $msg = sprintf($lang['Err0023'],$lang[$c->getType()]);
   $gotourl = $c->getUrl() ;
 }


 if ( $msg == "" ) {
   $dbconn->Begin("WORK");
   $msg = $c->delete();
   $dbconn->Commit("WORK");

   $gotourl = "address_select.php" ;
 } else {
   $gotourl= addUrlParameter($gotourl,"id=". $id);
 }

 $_SESSION['MSGID'.$c->id] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". $c->id);
 $gotourl = addSessionKey($gotourl);

 /* Go back to calendar */
 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: company_del.php,v 1.17.2.1 2003/07/24 09:05:08 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
