<?php
/*
 * Copyright 2001 - 2003 by Gero Kohnert
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("database","show");
 loadlayout();
 /**
  * display a database
  */
 class database_show extends layout {
   /**
    *
    */
   Function info() {
     global $tutos,$lang;

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">". sprintf($lang['Showing'],$this->obj->getFullName()) ."</th>\n";
     echo "</tr>\n";

     if ( is_object($this->obj->creator) ) {
       echo "<tr>\n";
       echo $this->showfield($lang['createdby']);
       echo " <td colspan=\"3\">". $this->obj->creator->getLink() ."</td>\n";
       echo "</tr>\n";
     }
     echo "<tr>\n";
     echo $this->showfield($lang['AdminDBName']);
     echo $this->showdata($this->obj->name);
     echo $this->showfield($lang['AdminDBType']);
     echo $this->showdata($this->obj->tlist[$this->obj->type]);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['AdminDBAlias']);
     echo $this->showdata($this->obj->alias);
     echo $this->showfield($lang['AdminDBPrefix']);
     echo $this->showdata($this->obj->prefix);

     # Do not show sensitive infos
     if ( $this->user->isAdmin() ) {  
       echo "</tr><tr>\n";
       echo $this->showfield($lang['AdminDBHost']);
       echo $this->showdata($this->obj->host);
       echo $this->showfield($lang['AdminDBPort']);
       echo $this->showdata($this->obj->port);
       echo "</tr><tr>\n";
       echo $this->showfield($lang['AdminDBUser']);
       echo $this->showdata($this->obj->user);
       echo $this->showfield($lang['AdminDBPass']);
       echo $this->showdata($this->obj->pass);
     }
     echo "</tr><tr>\n";
     echo $this->showfield($lang['DBLastAnalyze']);
     echo $this->showdata($this->obj->lastanalyze->getDateTime(),3);
     echo "</tr><tr>\n";
     echo $this->showfield($lang['DBLastDate']);
     echo $this->showdata($this->obj->lastsync->getDateTime());
     echo $this->showfield($lang['DBLastID']);
     echo $this->showdata($this->obj->lastid);

     echo "</tr><tr>\n";
     echo $this->showfield('cryptpw');
     echo $this->showdata($this->obj->crypt);
     echo $this->showfield($lang['CfgVersion']);
     echo $this->showdata($this->obj->version);

     if ( $this->obj->type == 3 ) {
       echo "</tr><tr>\n";
       echo $this->showfield($lang['AdminDBHome']);
       echo $this->showdata($this->obj->home,3);
     }
     if ( ($tutos[usedocmanagement] == 1) ) {
       echo "</tr><tr>\n";
       echo $this->showfield($lang['AdminDBRep']);
       echo $this->showdata($this->obj->repository,3);
     }

     echo "</tr><tr>\n";
     echo $this->showfield($lang['CfgLogo']);
     echo $this->showdata($this->obj->logo,3);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['CfgLogoLink']);
     echo $this->showdata($this->obj->logolink,3);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['CfgBugAutoName']);
     echo $this->showdata($this->obj->bugautoname,3);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['CfgInvAutoName']);
     echo $this->showdata($this->obj->invautoname,3);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['CfgVATlist']);
     echo $this->showdata($this->obj->vatlist,3);

     echo "</tr>\n";

     # References to modules
     show_module_infolists($this->user,$this->obj,4,$this->format);
     echo $this->obj->getHistoryLink(4);
     echo $this->DataTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
     global $tutos,$lang,$dbnr;

     echo "<tr><td>";
     if ( ($this->user->isAdmin()) ) {
       echo menulink("database_new.php",$lang['NewEntry'],$lang['DBCreate']) ."<br>";
     }
     if ( $this->obj->mod_ok()  ) {
       echo menulink("database_new.php?id=". $this->obj->id ,$lang['Modify'],sprintf($lang['DBModifyI'],$this->obj->getFullName())) ."<br>\n";
     }
     echo "<br>\n";
     if ( $this->obj->is_supported() ) {
       echo menulink("update.php?id=". $this->obj->id ,$lang['DBUpdate'],sprintf($lang['DBUpdateI'],$this->obj->getFullName())) ."<br>";
     }
     if ( ($this->obj->id >= 0) && $this->obj->see_ok() && (isset($tutos[dbname][$this->obj->id])) ) {
       echo menulink("logout.php?db=". $this->obj->id ,$lang['DBrelogin'],sprintf($lang['DBreloginI'],$this->obj->getFullName())) ."<br>\n";
     }

     echo menulink("admin_sync.php",$lang['AdminDBSync'],$lang['AdminDBSync']) ."<br>";

     echo "</td></tr>";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;
    
     $this->name = $lang['DBDetail'];

     $this->obj = new database($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # menu
     $x = database::getOverviewLink($this->user);
     $this->addmenu($x);
     add_module_addlinks($this,$this->obj);

     # add this page to the browsehistory of the users session
     $this->addtohistory();
   }
 }


 $l = new database_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: database_show.php,v 1.28.2.2 2003/07/01 19:18:05 gokohnert Exp $
    $Author: gokohnert $
-->
