<?php
/**
 * Copyright 2000 - 2003 by Gero Kohnert
 *
 * @modulegroup file
 * @module file_new
 * @package file
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('file','new');
 loadmodule('file');
 loadlayout();

 /**
  * change/modify a bug
  */
 class file_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $tutos,$lang,$table;

     echo "<form name=\"fileadd\" enctype=\"multipart/form-data\" method=\"post\" action=\"file_ins.php\">\n";

     if ( $this->obj->id != -1 ) {
       $this->addHidden("id",$this->obj->id);
     }
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">". $lang['File'] ."</th>\n";
     echo "</tr>\n";

     if ( $this->obj->id > 0 ) {
       echo "<tr>\n";
       echo " <td colspan=\"3\">&nbsp;</td>\n";
       echo " <td align=\"right\" colspan=\"1\">". acl_link($this->obj) ."</td>\n";
       echo "</tr>\n";
     }
     echo "<tr>\n";
     echo $this->showfieldc($lang['FileNameDoc'],1,"name");
     echo " <td><input id=\"name\" maxlength=\"".$table['file']['name'][size]."\" name=\"name\" value=\"". $this->obj->name ."\"></td>\n";
     echo $this->showfieldc($lang['FileVersion'],0,"version");
     echo " <td><input id=\"version\" size=\"10\" maxlength=\"".$table['file']['version'][size]."\" name=\"version\" value=\"". $this->obj->version ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['FileReference']);
     if ($this->obj->ref != -1 ) {
       echo " <td>". $lang[$this->obj->ref->gettype()] ." ". $this->obj->getRefLink() ."</td>\n";
     } else {
       echo " <td>". $lang['HistoryDeleted'] ." (". $this->obj->link_id .")</td>\n";
     }
     echo $this->showfieldc($lang['FileAuthor'],0,"a");
     echo " <td>\n";
     select_from_array_or_input($this->obj,"a",$this->obj->author,0);
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['FileName'],0,"file");
     echo " <td colspan=\"3\"><input id=\"file\" size=\"40\" name=\"file\" type=\"file\" value=\"". $this->obj->filename ."\">\n";
     if ( $this->obj->id != -1 ) {
       echo "<br><font size=\"-1\">". $this->obj->filename ."</font>";
     }
     echo "<br><font size=\"-1\">(max. allowed size = ". ini_get('upload_max_filesize') ." Bytes)</font>";
     echo "</td>\n";
     echo "</tr>\n";

     if ( ($this->obj->id != -1) && ($this->obj->vsys != 0) ) {
       echo "<tr>\n";
       echo $this->showfield($lang['FileVersioning'],0,"save");
       echo " <td id=\"save\" colspan=\"3\">\n";
       echo " <font size=\"-1\">". $lang['FileVersioningI'] ."</font><br>\n";
       echo "  <input type=\"radio\" name=\"save\" value=\"0\">&nbsp;". sprintf($lang['FileOverwrite'],$this->obj->getFullname()) ."<br>\n";
       echo "  <input type=\"radio\" name=\"save\" value=\"1\" checked>&nbsp;". sprintf($lang['FileSave'],$this->obj->name,$this->obj->version) ."\n";
       echo " </td>\n";
       echo "</tr>\n";
     }
     if ( $this->obj->id == -1 ) {
       echo "<tr>\n";
       echo $this->showfield($lang['FileVersionType'],0,"vsys");
       echo " <td id=\"vsys\" colspan=\"3\">&nbsp;\n";
       echo " <font size=\"-1\">". $lang['FileVersionTypeI'] ."</font><br>\n";
       echo "  <input type=\"radio\" name=\"vsys\" value=\"0\"". ( $this->obj->vsys == 0 ? " checked":"") .">&nbsp;none \n";
       echo "  <input type=\"radio\" name=\"vsys\" value=\"1\"". ( $this->obj->vsys == 1 ? " checked":"") .">&nbsp;TUTOS \n";
       if ( file_exists($tutos[ci]) && is_executable($tutos[ci]) ) {
         echo "  <input type=\"radio\" name=\"vsys\" value=\"2\"". ( $this->obj->vsys == 2 ? " checked":"") .">&nbsp;RCS \n";
       }
       echo " </td>\n";
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo $this->showfield($lang['FileLocking'],0,"locked");
     echo " <td id=\"locked\" colspan=\"3\">&nbsp;\n";
     echo "  <input type=\"radio\" name=\"locked\" value=\"0\" ". ( $this->obj->locked == 0 ? " checked":"") .">&nbsp;". $lang['FileUnlocked'] ."\n";
     echo "  <input type=\"radio\" name=\"locked\" value=\"". $this->user->id ."\"". ( $this->obj->locked == $this->user->id ? " checked":"") .">&nbsp;". sprintf ($lang['FileLocked'], $this->user->getLink()) ."\n" ;
     echo " </td>\n";
     echo "</tr>\n";

     module_addforms($this->user,$this->obj,4);

     echo "<tr>\n";
     if ( isset($this->obj->id) && ($this->obj->id != -1) ) {
       submit_reset(0,1,1,1,1,0);
     } else {
       submit_reset(0,-1,1,1,1,0);
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
     hiddenFormElements();
     $this->addHidden("gotourl","file/file_new.php");
     $this->addHidden("link_id", $this->obj->link_id);
     echo $this->getHidden();
     echo "</form>\n";
     echo $lang['FldsRequired'] ."\n";
     echo $this->setfocus("fileadd.name");
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang,$tutos;

     $this->obj = new tutos_file($this->dbconn);
     if ( isset($_GET['id']) ){
       $this->name = $lang['FileMod'];
       $this->obj->read($_GET['id']);
       if ( $this->obj->id < 0 ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true ;
       } else if ( ! $this->obj->mod_ok() ) {
         $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
       $this->name .= ": ".$this->obj->getFullName();
     } else {
       $this->name = $lang['FileCreation'];
       if ( isset($_GET['link_id']) ){
         $this->obj->link_id = $_GET['link_id'];
       } else {
         $this->obj->link_id = $this->user->id;
       }
       if ( ! $this->user->feature_ok(usedocmanagement,PERM_NEW) ) {
         $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     }
     if ( isset($_GET['name']) ){
       $this->obj->name = StripSlashes($_GET['name']);
     }
     if ( isset($_GET['version']) ){
       $this->obj->version = StripSlashes($_GET['version']);
     }
     preset_from_array_or_input($this->obj,'author',"a");

     $this->obj->read_reference();
     # menu
     $m = tutos_file::getSelectLink($this->user,$lang['Search']);
	 $m[category][] = "obj";
     $this->addmenu($m);

     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "file/file_del.php?id=". $this->obj->id,
                   text => $lang['Delete'],
                   info => sprintf($lang['FileDeleteI'],$this->obj->getFullName()),
                   confirm => true,
                   category => array("file","del","obj")
                 );
       $this->addMenu($x);
     }

     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new file_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: file_new.php,v 1.7.2.2 2003/07/31 17:56:14 gokohnert Exp $
    $Author: gokohnert $
-->