<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * send a new mail
 *
 * @modulegroup mail
 * @module mail_ins
 * @package mail
 */ 
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("mail","ins");

 $msg = "";
 if ( ! isset($_POST['gotourl']) ) {
   $gotourl = "mytutos.php";
 } else {
   $gotourl = $_POST['gotourl'];
 }
 $m = new mail();
 $m->setFrom($current_user);
 $m->setSubject(StripSlashes($_POST['subject']));

 $m->from->read_locs_data();
 $found = 0;
 if (isset($_POST['from'])) {
   $t = split(",",$_POST['from']);
   if ( isset($m->from->location) ) {
     @reset($m->from->location);
     while( list ($i,$f) = @each ($m->from->location)) {
       if ( $f->id == $t[1] ) {
         if ( $t[0] == 1 ) {
           $from = $f->email_1;
           $found = 1;
         }
         if ( $t[0] == 2 ) {
           $from = $f->email_2;
           $found = 1;
         }
       }
     }
   }
 }
 if ($found == 0 ) {
   $msg .= "Missing senders mail address ";
 } else {
   $m->setFromTxt($from);
   # bcc will only work with sendmail not with smtp ;-(
   $m->addHeader("Bcc","<".$from.">");
 }

 if (isset($_POST['to'])) {
   $t = split("[,;]",$_POST['to']);
   $gotourl = addUrlParameter($gotourl,"to[]=". $_POST['to']);
   for ($j = 0; $j < count($t); $j++) {
     $m->addTo($t[$j]);
   }
 }  

 // team members are sent in bcc
 if (isset($_POST['toid'])) {
   $gotourl = addUrlParameter($gotourl,"toid=". $_POST['toid']);
   $to = getObject($dbconn,$_POST['toid']);
   if ( $to->getType() == "team" ) {
     $m->addBcc($to);
   } else if ( $to->getType() == "product" ) {
     $to->readroles();
     foreach ($to->role as $role => $f) {
       if ( isset ($to->role[$role] ) && is_array ($to->role[$role]) ) {
         foreach($to->role[$role] as $i => $o) {
           $m->addTo($o);
         }
       }
     }
   } else if ( $to->getType() == "group" ) {
     $to->read_member();
     foreach( $to->member as $i => $o) {
       $m->addTo($o);
     }
   }
 }

 $t = split("[,;]",$_POST['cc']);
 $gotourl = addUrlParameter($gotourl,"cc[]=". $_POST['cc']);
 for ($j = 0; $j < count($t); $j++) {
   $m->addCc($t[$j]);
 }
 $t = split("[,;]",$_POST['bcc']);
 if($t == ""){
   $gotourl = addUrlParameter($gotourl,"bcc[]=". $_POST['bcc']);
 }
 for ($j = 0; $j < count($t); $j++) {
   $m->addBcc($t[$j]);
 }
 if (trim($_POST['body']) == "") {
   $msg .= "empty message not sent";
#   $msg .= "<br>". $m->getToAscii();
 }

 $m->addBody($_POST['body'], "text/plain", "TUTOS", "", $lang['content_encoding']);
 $gotourl = addUrlParameter($gotourl,"body=". Base64_Encode($_POST['body']));

 if ( isset($HTTP_POST_FILES['file']) ) {
   $farr = $HTTP_POST_FILES['file'];
   if ( $farr != "none" && file_exists($farr['tmp_name']) && (filesize($farr['tmp_name']) > 0) ) {
     $fd = fopen ($farr['tmp_name'], "rb");
     $body = fread($fd, filesize($farr['tmp_name']));
     fclose($fd);
     $m->addBody($body,$farr['type'],"TUTOS Attachment",$farr['name']);
     $gotourl= addUrlParameter($gotourl,"filepath=". $farr['name']);
   }
 }

 if ( $msg == "" ) {
   $msg .= $m->send();
 }

 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));
 $gotourl = addSessionKey($gotourl);
 
 // bug when $gotourl is too long 
 if ( strlen($gotourl) > 2000 ){
   if ( ! isset($_POST['gotourl']) ) {
     $gotourl = "mytutos.php";
   } else {
     $gotourl = $_POST['gotourl'];
   }
   $gotourl = addUrlParameter($gotourl,"msg=Mail sent.");
 }

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
/*
 *  CVS Info:  $Id: mail_ins.php,v 1.24.2.2 2003/06/18 14:34:32 gokohnert Exp $
 *  $Author: gokohnert $
 */
?>
