<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * display all product info
 *
 * @modulegroup product
 * @module product_show
 * @package product
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'appointment.pinc';
 include_once 'timetrack.pinc';
 include_once 'bug.pinc';
 include_once 'task.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','show');
 loadlayout();

 /**
  * display a product
  */
 class product_show extends layout {
   /**
    * List Roles
    */
   Function showrole($role) {
     global $lang;

     if ( isset($this->obj->role[$role]) && (count($this->obj->role[$role]) > 0) ) {
       echo "<tr>\n";
       echo $this->showfield($lang['ProdRole'][$role]);
       echo " <td colspan=\"3\">";
       $n = 0;
       foreach ($this->obj->role[$role] as $i => $r) {
         if ( $n > 0 ) {
           echo  "<br>\n";
         }
         if ( $r->getType() == "department" ) {
           echo  $r->getLink( $r->getFullName() ." / ". $r->company->getFullName() );
         } else {
           echo  $r->getLink();
         }
         if ( !empty($this->obj->roledesc[$role][$i]) ) {
           echo  "&nbsp;(". $this->obj->roledesc[$role][$i] .")";
         }
         $n++;
       }
       echo "</td></tr>\n";
     }
   }
   /**
    * display the info
    */
   Function info() {
     global $tutos,$lang;

     if ( $this->obj->id < 0 ) {
       return;
     }

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">". sprintf($lang['Showing'],$lang[$this->obj->getType()]) ."</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo " <td>". $lang['createdby'] ."</td><td>". $this->obj->creator->getLink() ."</td>\n";
     echo " <td>". $lang['atDateTime'] ."</td><td>". $this->obj->creation->getLinkDateTime() ."</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['ProdName']);
     echo $this->showdata(myentities($this->obj->name),3);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['ProdVersion']);
     echo $this->showdata(myentities($this->obj->version),3);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['ProdState']);
     echo $this->showdata($lang['ProdStates'][$this->obj->state],1);
     if ( (($this->obj->state == 0) || ($this->obj->state == 5) || ($this->obj->state == 4)) && ( $this->obj->probability != "" ) ) {
       echo $this->showfield($lang['ProdProb']);
       echo $this->showdata($this->obj->probability ."%",1);
     } else {
       echo "<td colspan=\"2\">&nbsp;</td>\n";
     }
     echo "</tr>\n";

     $this->obj->readroles();
     foreach ($lang['ProdRole'] as $role => $x ) {
       $this->showrole($role);
     }
     echo "<tr>\n";
     echo $this->showfield($lang['ProdDesc']);
     echo $this->showdata(myentities($this->obj->description) ."&nbsp;",3);
     echo "</tr>\n";

     if ( $this->obj->desc1 != "") {
       echo "<tr>\n";
       echo $this->showfield($lang['ProdDesc1']);
       echo $this->showdata(myentities($this->obj->desc1),3);
       echo "</tr>\n";
     }
     if ( $this->obj->desc2 != "" ) {
       echo "<tr>\n";
       echo $this->showfield($lang['ProdDesc2']);
       echo $this->showdata(myentities($this->obj->desc2),3);
       echo "</tr>\n";
     }
     # Classification
     for ( $cl = 1;$cl <= $this->obj->classes; $cl++) {
       if ( count($this->obj->cl[$cl]) > 0 ) {
         echo "<tr>\n";
         echo $this->showfield($lang['ProdClass'.$cl]);
         echo "  <td colspan=\"3\">\n";
         @reset($this->obj->cl[$cl]);
         while ( list ($i,$f) = @each ($this->obj->cl[$cl]) ) {
           if ( isset ($lang['ProdClasses'.$cl][$f]) ) {
             echo $lang['ProdClasses'.$cl][$f] . "<br>\n";
           } else {
             echo $f . "<br>\n";
           }
         }
         echo "  </td>\n";
         echo "</tr>\n";
       }
     }

     echo "<tr>\n";
     echo $this->showfield($lang['ProdPrice']);
     $x= array($this->obj->price,$this->obj->currency);
     echo $this->showdata(handle('money',$x,number_format($this->obj->price,2,$lang['DecPoint'],$lang['ThousandPoint']) ."&nbsp<b>". $this->obj->currency ."</b>"));

     echo $this->showfield($lang['ProdCost']);
     $x= array($this->obj->cost,$this->obj->currency);
     echo $this->showdata(handle('money',$x,number_format($this->obj->cost,2,$lang['DecPoint'],$lang['ThousandPoint']) ."&nbsp<b>". $this->obj->currency ."</b>"));
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['ProdStart']);
     echo "  <td>". $this->obj->p_start->GetLinkDate() ."</td>\n";
     echo $this->showfield($lang['ProdEnd']);
     echo "  <td>". $this->obj->p_end->GetLinkDate() ."</td>\n";
     echo "</tr>\n";

     if ( $this->obj->path != "" ) {
       echo "<tr>\n";
       echo $this->showfield($lang['ProdPath']);
       echo "  <td colspan=\"3\"><a href=\"". $this->obj->path ."\">". myentities($this->obj->path) ."</a></td>\n";
       echo "</tr>\n";
     }

     bug::infolist($this->user,$this->obj,4,$this->format);
     appointment::infolist($this->user,$this->obj,4,$this->format);

     if ( $this->user->feature_ok(usetaskmanagement,PERM_SEE) ) {
       $this->obj->readTasks();
       if ( count($this->obj->tasklist) >0 ) {
         @reset($this->obj->tasklist);
         echo "<tr>\n";
         echo $this->showfield($lang['ProdTasks']);
         echo " <td valign=\"top\" colspan=\"3\">\n";
         echo $this->theme->getImage(folder,'list') ." ".
	   makelink("task_overview.php?id=".
		    $this->obj->id, $lang['TaskOverview'],
		    sprintf($lang['TaskOverviewInfo'],
			    $this->obj->getFullName()));

	 echo makelink("task_overview.php?id=".$this->obj->id."&amp;fld=worker",
		       " [++] ", sprintf($lang['TaskOverviewInfo'],
				     $this->obj->getFullName()));
         echo "<br>\n";
         $n = 1;
         $x = count($this->obj->tasklist);

         if ( $this->format == "paper" ) {
           $rows = count($this->obj->tasklist);
         } else {
           $rows = $tutos[maxshort];
         }

         while ( list ($i,$f) = @each ($this->obj->tasklist) ) {
           if ( ($n >= $rows) && ( $x != $rows ) ) {
             echo  $this->theme->getImage(folder,'list') ." ". makelink("task_overview.php?id=". $this->obj->id,sprintf($lang['AllEntries'], count($this->obj->tasklist)));
             break;
           }
           echo $this->theme->getImage(paper,'list') ." ". $f->getLink() ."<br>\n";
           $n++;
         }
         echo " </td>\n";
         echo "</tr>\n";
       }
     }

     product::infolist($this->user,$this->obj,4,$this->format);
     # References to modules
     show_module_infolists($this->user,$this->obj,4,$this->format);

     if ( $this->user->feature_ok(usetimetrack,PERM_SEE) ) {
       $timesum = 0.0;
       $costsum = 0.0;
       $this->obj->readTimetrackSum();
       $rows = 0;
       if ( $this->obj->timetracksum > 0) {
         $rows++;
       }
       @reset ($this->obj->tsum);
       while( list ($i,$f) = @each ($this->obj->tsum)) {
         if ( $this->obj->tsum[$i] > 0 ) {
           $rows++;
         }
       }
       $r = 0;
       if ( $rows > 0 ) {
         if ( $rows > 1 ) {
           $rows++;
         }
         echo "<tr>\n";
         echo "<td class=\"desc\" valign=\"top\" rowspan=\"". $rows ."\">". $lang['Timetrack'] ;
         echo "</td>\n";

         if ( $this->obj->timetracksum > 0) {
           echo " <td valign=\"top\" align=\"right\">\n";
           echo makelink("timetrack_overview.php?link_id=". $this->obj->id ,number_format($this->obj->timetracksum,2),$lang['TimetrackOverview']);
           echo " </td>\n";
           echo " <td align=\"left\">". $lang['hours'] ."</td>\n";
           echo " <td>&nbsp;</td>\n";
           echo "</tr>\n";
           $r = 1;
           $timesum += $this->obj->timetracksum;
         }
         @reset ($this->obj->tsum);
         while( list ($i,$f) = @each ($this->obj->tsum)) {
           if ( $this->obj->tsum[$i] > 0 ) {
             if ( $r == 1 ) {
               echo "<tr>\n";
             }
             echo " <td valign=\"top\" align=\"right\">";
             echo makelink("timetrack_overview.php?link_id=". $this->obj->id ."&amp;show=".$i,number_format($this->obj->tsum[$i],2),$lang['TimetrackOverview']);
             echo " </td>\n";
             echo " <td align=\"left\">". $lang['hours'] ."</td>\n";
             echo " <td>(". $lang[$i] .")</td>\n";
             echo "</tr>\n";
             $timesum += $this->obj->tsum[$i];
             $r = 1;
           }
         }
       }
       if ( $rows > 1 ) {
         # Summary
         echo "<tr>\n";
         echo " <td valign=\"top\" align=\"right\">==&nbsp;";
         echo makelink("timetrack_overview.php?link_id=". $this->obj->id ."&amp;show=all" ,number_format($timesum,2),$lang['TimetrackOverview']);
         echo " </td>\n";
         echo " <td colspan=\"2\" align=\"left\">". $lang['hours'] ."</td>\n";
         echo "</tr>\n";
       }
     }

     if ( $this->format != "paper" ) {
       echo $this->obj->getHistoryLink(4);
     }
     echo $this->DataTableEnd();
   }
   /**
    * naviagtion
    */
   Function navigate() {
     global $tutos,$lang;

     echo "<tr><th>".$lang['Tasks']."</th></tr>\n";
     echo "<tr><td>\n";

     if ( ($this->obj->id > 0) && $this->obj->see_ok() ) {
       if ( $this->user->feature_ok(usetaskmanagement,PERM_SEE) ) {
         echo menulink("task_overview.php?id=".$this->obj->id,$lang['TaskOverview'],sprintf($lang['TaskOverviewInfo'], $this->obj->getFullName()));
         echo "<br>\n";

         echo menulink("task_overview.php?id=".$this->obj->id."&amp;fld=worker",$lang['TaskOverview']."++",sprintf($lang['TaskOverviewInfo'], $this->obj->getFullName()));
         echo "<br>\n";

         if( $tutos[usejpgraph] ) {
           echo menulink("task_gantt.php?id=".$this->obj->id, $lang['TaskGantt']);
           echo "<br>\n";
         }
       }
       if ( $this->user->feature_ok(usetaskmanagement,PERM_NEW) ) {
         if ( $this->obj->mod_ok() > 0 ) {

           echo menulink("task_import_csv.php?p_id=".$this->obj->id, "Import CSV"). "<br>\n";
         }
       }

       echo "</td></tr>\n<tr><td>\n";
       //       echo checklist::getaddlink($this->user,$this->obj);
     }
     echo "</td></tr>\n";

     echo "<tr><th>".$lang['Product']."</th></tr>\n";
     echo "<tr><td>\n";

     echo menulink("product_show.php?format=paper&amp;id=".$this->obj->id,$lang['Printable'], $lang['PrintableInfo']);
     echo "</td></tr>\n";

   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['ProductsDetail'];
     $this->obj = new product($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->name = $lang['ProductsDetail'].": ". $this->obj->getFullName();
     }

     # Menu      
     $x = product::getSelectLink($this->user,$lang['Search']);
	 $x[category][] = "obj";
     $this->addMenu($x);
     if ( $this->user->feature_ok(useprojects,PERM_NEW) ) {
       $x = array( url => "product_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['ProdCreateInfo'],
                   category => array("product","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( url => "product_new.php?id=".$this->obj->id,
                   text => $lang['Modify'],
                   info => sprintf($lang['ProdModInfo'],$this->obj->getFullname()),
                   category => array("product","mod","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "product_del.php?id=".$this->obj->id,
                   text => $lang['Delete'],
                   info => sprintf($lang['ProdDelInfo'],$this->obj->getFullname()),
                   category => array("product","del","obj"),
                   confirm => true
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->user->feature_ok(usetimetrack,PERM_NEW) ) {
       $x = array( url =>"timetrack_new.php?mode=1&amp;lid=".$this->obj->id,
                   text => $lang['TTRecord'],
                   info => $lang['TTRecord'],
                   category => array("timetrack","module","new"),
                 );
       $this->addMenu($x);
     }

     $x = timetrack::getaddlink($this->user,$this->obj);
     $this->addMenu($x);
     $x = bug::getaddlink($this->user,$this->obj);
     $this->addMenu($x);
     $x= task::getaddlink($this->user,$this->obj);
     $this->addMenu($x);
     $x = $this->obj->getMailLink();
     $this->addMenu($x);
     # module
     add_module_addlinks($this,$this->obj);

     # add this page to the browsehistory of the users session
     $this->addtohistory();
   }
 }

 $l = new product_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: product_show.php,v 1.77.2.5 2003/10/01 09:34:31 gokohnert Exp $
    $Author: gokohnert $
-->