<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup task
 * @module task_show
 * @package task
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'product.pinc';
 include_once 'bug.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","show");
 loadlayout();

 /**
  * show a task
  */
 class task_show extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     echo $this->DataTableStart();
     echo " <tr>\n";
     echo "  <th colspan=\"4\">";
     echo $lang['TaskDetail'].": ". $this->obj->getFullName();
     echo "  </th>\n";
     echo " </tr>\n";

     echo " <tr>\n";
     echo "  <td colspan=\"4\">". sprintf ($lang['TaskCreation'],$this->obj->creator->getLink(),$this->obj->creation->getDateTime()) ."</td>\n";
     echo " </tr>\n";

     echo " <tr>\n";
     echo $this->showfield($lang['TaskName']);
     echo $this->showdata(myentities($this->obj->name));
     echo $this->showfield($lang['TaskState']);
     echo $this->showdata($lang['TaskStates'][$this->obj->state],3);
     echo " </tr>\n";
     echo " <tr>\n";
     echo $this->showfield($lang['TaskWorker']);
     echo "<td colspan=\"3\">\n";
     $pre = "";
     foreach ($this->obj->worker as $i => $x) {
#       echo $pre.$i." ". $x;
       echo $pre.$this->obj->worker[$i]->getLink();
       $pre = "<br>\n";
     }
     echo " </td>\n";
     echo " </tr>\n";

     if ( ($this->obj->parent != -1) && ($this->obj->parent->gettype() != "address") ) {
       echo " <tr>\n";
       echo $this->showfield($lang['TaskSubTask']);
       echo "  <td colspan=\"3\">\n";
       $x = $this->obj->parent;
       $pre = "";
       while ( isset ( $x ) ) {
         echo $pre . $lang[$x->gettype()] . "&nbsp;" . $x->getLink();
         if (isset($x->parent))
           $x = $x->parent;
         else
           unset($x);
         $pre = " -&gt; ";
       }
       echo "  </td>\n";
       echo " </tr>\n";
     }

     echo " <tr>\n";
     echo $this->showfield($lang['TaskDesc']);
     echo "  <td colspan=\"3\" class=\"pre\"><pre>". wordwrap(urlReplace($this->obj->desc),80) ."</pre></td>\n";
     echo " </tr>\n";

     echo " <tr>\n";
     echo $this->showfield($lang['TaskSched']);
     echo "  <td>". $lang['DateTimeFrom'] .":&nbsp;". $this->obj->s_start->getDate() ."</td>\n";
     echo "  <td colspan=\"2\">". $lang['DateTimeTill'] .":&nbsp;". $this->obj->s_end->getDate() ."</td>\n";
     echo " </tr>\n";

     echo " <tr>\n";
     echo $this->showfield($lang['TaskReal']);
     echo "  <td>". $lang['DateTimeFrom'] .":&nbsp;". $this->obj->r_start->getDateTime() ."</td>\n";
     echo "  <td colspan=\"2\">". $lang['DateTimeTill'] .":&nbsp;". $this->obj->r_end->getDateTime() ."</td>\n";
     echo " </tr>\n";

     echo " <tr>\n";
     echo $this->showfield($lang['TaskVolumeFull']);
     echo "  <td>".  number_format($this->obj->volume,2) ." ". $lang['hours'] ."</td>\n";
     echo $this->showfield($lang['TaskVolumeDone']);
     echo "  <td>".  makelink("timetrack_overview.php?link_id=" .$this->obj->id , number_format($this->obj->volume_done,2) , $lang['TimetrackOverview']) ." ". $lang['hours'] ."</td>\n";
     echo " </tr>\n";

     if( $this->obj->volume_todo != -1 ) {
       echo " <tr>\n";
       echo $this->showfield($lang['TaskVolumeTodo']);
       echo "  <td colspan=\"3\">".  number_format($this->obj->volume_todo,2) ." ". $lang['hours'] ."</td>\n";
       echo " </tr>\n";
     }

     bug::infolist($this->user,$this->obj,4,$this->format);

     $this->obj->readTasks();
     if ( count($this->obj->tasklist) > 0 ) {
       @reset($this->obj->tasklist);
       echo "<tr>\n";
       echo $this->showfield($lang['Tasks']);
       echo " <td valign=\"top\" colspan=\"3\">\n";
       echo  makelink("task_overview.php?id=". $this->obj->id,$lang['TaskOverview'],sprintf($lang['TaskOverviewInfo'],$this->obj->getFullName()));
       echo "<br>\n";
       $n = 0;
       while ( list ($i,$f) = @each ($this->obj->tasklist) ) {
         if ( $n > 2 ) {
         }
         echo "  ". $f->getLink() ."<br>\n";
        $n++;
       }
       echo " </td>\n";
       echo "</tr>\n";
     }
     if ( $this->user->feature_ok(usetimetrack,PERM_SEE) ) {
       $timesum = 0.0;
       $costsum = 0.0;
       $this->obj->readTimetrackSum();
       $rows = 0;
       if ( $this->obj->timetracksum > 0) {
         $rows++;
       }
       @reset ($this->obj->tsum);
       while( list ($i,$f) = @each ($this->obj->tsum)) {
         if ( $this->obj->tsum[$i] > 0 ) {
           $rows++;
         }
       }
       $r = 0;
       if ( $rows > 0 ) {
         if ( $rows > 1 ) {
           $rows++;
         }
         echo "<tr>\n";
         echo "<td class=\"desc\" valign=\"top\" rowspan=\"". $rows ."\">". $lang['Timetrack'] ;
         echo "</td>\n";

         if ( $this->obj->timetracksum > 0) {
           echo " <td valign=\"top\" align=\"right\">\n";
           echo makelink("timetrack_overview.php?link_id=". $this->obj->id ,number_format($this->obj->timetracksum,2),$lang['TimetrackOverview']);
           echo " </td>\n";
           echo " <td align=\"left\">". $lang['hours'] ."</td>\n";
           echo " <td>&nbsp;</td>\n";
           echo "</tr>\n";
           $r = 1;
           $timesum += $this->obj->timetracksum;
         }
         @reset ($this->obj->tsum);
         while( list ($i,$f) = @each ($this->obj->tsum)) {
           if ( $this->obj->tsum[$i] > 0 ) {
             if ( $r == 1 ) {
               echo "<tr>\n";
             }
             echo " <td valign=\"top\" align=\"right\">";
             echo makelink("timetrack_overview.php?link_id=". $this->obj->id ."&show=".$i,number_format($this->obj->tsum[$i],2),$lang['TimetrackOverview']);
             echo " </td>\n";
             echo " <td align=\"left\">". $lang['hours'] ."</td>\n";
             echo " <td>(". $lang[$i] .")</td>\n";
             echo "</tr>\n";
             $timesum += $this->obj->tsum[$i];
             $r = 1;
           }
         }
       }
       if ( $rows > 1 ) {
         # Summary
         echo "<tr>\n";
         echo " <td valign=\"top\" align=\"right\">==&nbsp;";
         echo makelink("timetrack_overview.php?link_id=". $this->obj->id ."&show=all" ,number_format($timesum,2),$lang['TimetrackOverview']);
         echo " </td>\n";
         echo " <td colspan=\"2\" align=\"left\">". $lang['hours'] ."</td>\n";
         echo "</tr>\n";
       }
     }

     # References to modules
     show_module_infolists($this->user,$this->obj,4,$this->format);

     echo $this->obj->getHistoryLink(4);
     echo $this->DataTableEnd();

     $c = $this->obj->getcompletion();
     $m1 = max($c,100);
     $m2 = min($c,100);
 
     $w = 400;

     # One Percent
     $p = $w / $m1;

     $s = Round($p * 20);

     DoubleTableStart(1,0);
     echo " <tr>\n";
     echo "  <th colspan=\"3\">". sprintf($lang['TaskCompleted'],$c) ."</th>\n";
     echo " </tr>\n";
     echo " <tr>\n";
     echo "  <td colspan=\"2\">0 - 100 </td>\n";
     echo "  <td align=\"center\" colspan=\"". ($w - 5 * $s) ."\"><font color=\"red\">&gt; 100</font></td>\n";
     echo " </tr>\n";
     echo " <tr>\n";
     # Work done in time/volume
     if ( Round($m2 * $p) > 0 ) {
       echo "  <td class=\"taskdone\"><img height=\"20\" width=\"". Round($m2 * $p)."\" src=\"". $tutos['base'] ."/html/green.png\" alt=\"--------\"></td>\n";
     }
     # Work to do
     if ( Round((100 - $c) * $p) > 0 ) {
       echo "  <td class=\"tasktodo\"><img height=\"20\" width=\"". Round((100 - $c) * $p)."\" src=\"". $tutos['base'] ."/html/red.png\" alt=\"--------\"></td>\n";
     }
     # Work done more than scheduled
     if ( Round(($c - 100) * $p) > 0 ) {
       echo "  <td class=\"taskmuch\"><img height=\"20\" width=\"". Round(($c - 100) * $p)."\" src=\"". $tutos['base'] ."/html/blue.png\" alt=\"--------\"></td>\n";
     }
 
     echo " </tr>\n";
     DoubleTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['TaskDetail'];

     $this->obj = new task($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     }

     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->name .=": ". $this->obj->getFullName();
     }

     if ($this->stop) {
       return;
     }
     # menu

     $x = task::getaddlink($this->user,$this->obj->parent,$lang['NewEntry']);
     $this->addMenu($x);

     $x = task::getaddlink($this->user, $this->obj, $lang['TaskNewSubtask']);
     $this->addMenu($x);

     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( url => "task_new.php?id=".$this->obj->id,
                   text => $lang['Modify'],
                   info => sprintf($lang['TaskModify'],$this->obj->getFullname()),
                   category => array("task","mod","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "task_del.php?id=".$this->obj->id,
                   text => $lang['Delete'],
                   info => sprintf($lang['TaskDelete'],$this->obj->getFullname()),
                   category => array("task","del","obj"),
                   confirm => true
                 );
       $this->addMenu($x);
     }

     if ( $this->obj->mod_ok() ) {
       $x = bug::getaddlink($this->user,$this->obj);
       $this->addMenu($x);
     }
     $x = timetrack::getaddlink($this->user,$this->obj);
     $this->addMenu($x);
     add_module_addlinks($this,$this->obj);

     # add this page to the browsehistory of the users session
     $this->addtohistory();
   }
 }

 $l = new task_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: task_show.php,v 1.55.2.6 2003/08/22 17:48:07 gokohnert Exp $
    $Author: gokohnert $
-->