<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup team
 * @module team_overview
 * @package team
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'product.pinc';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("team","overview");

 /**
  * display an overview of teams
  */
 class team_overview extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $tutos,$lang;


     $n = $this->result->numrows();


     # Make a big array of all visible teams
     $x = 0;
     while ( $x < $n ) {
       $b = new team($this->dbconn);
       $b->read_result($this->result,$x);
       $x++;
       if ( ! $b->see_ok() ) {
         unset($b);
         continue;
       }
       $tlist[] = &$b;
       unset($b);
     }
     $n = count($tlist);
     $this->result->free();
     if ( 0 == $n) {
       echo $this->error( $lang['Err0048'] );
       return;
     }

     $this->assign('action', 'team_overview.php');
     $this->assign('Team', $lang['Team']);
     $this->assign('TeamManager', $lang['TeamManager']);
     $this->assign('TeamCount', $lang['TeamCount']);

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     // Prepare navigation bar
     $this->assign_navbar($a, $end, $n, $this->search);

     $teams = array();

     while ( ($a < $n) && ($a < $end) ) {
       $t = $tlist[$a];

       if( is_object($t->owner) )
	 $owner = array('name'  => $t->owner->getFullName(),
			'title' => $t->owner->getFullName(),
			'link'  => $t->owner->getUrl());
       else
	 $owner = -1;

       $count = count($t->ids);

       /**
	* Care about owner presence in the list.
	*  see team::read_result for details
	*  owner count is 2 when owner is also a team member
	*/
       if( is_object($t->owner) && $t->ids[$t->owner->id] == 1)
	 $count = $count - 1;

       $teams[] = array('name'    => $t->getFullName(),
			'title'   => $t->getFullName(),
			'link'    => $t->getUrl(),
			'owner'   => $owner,
			'members' => $count);

       $a++;
     }
     $this->assign('teams', $teams);

     $this->template('team_overview');
   }

   /**
    *
    */
   Function navigate() {
   }

   /**
    * do mass actions
    */
   Function action() {
     global $msg,$lang;

     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $obj = new team($this->dbconn);
         $obj->read($val);
         if ( $obj->id != $val ) {
           continue;
         }
         if ( $obj->del_ok() ) {
           $msg .= $lang['Delete'] ."&nbsp;". $obj->getFullName() ."<br>";
           $msg .= $obj->delete();
         } else {
           $msg .= $obj->getLink() .": ". sprintf($lang['Err0023'],$lang[$obj->getType()]) ."<br>";
         }
         unset($obj);
       }
       $this->dbconn->Commit("WORK");
       return;
     }
     if ( $_GET['action'] == -4 ) {
       $this->redirect = acl_action();
       return;
     }
     if (class_exists('watchlist')) {
       watchlist::parse_action($this->user);
     }
   }

   /**
    *
    */
   Function prepare() {
     global $lang;

     $this->name   = $lang['TeamOverview'];
     $this->search = array();

     $this->link1 = "team_overview.php";
     $this->q = "SELECT * FROM ". $this->dbconn->prefix ."teams";
     $pre = " WHERE ";

     if ( isset($_GET['name'])
	  && ($_GET['name'] != "*") && ($_GET['name'] != "") ) {
       $this->q .= $pre .  $this->dbconn->Like("name",$_GET['name']);
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,
				      "name=". UrlEncode($_GET['name']));

       $this->search['name'] = $_GET['name'];
     }

     check_dbacl( $this->q, $this->user->id);

     # sorting
     $xxx = "";
     $this->link2 = $this->link1;
     order_parse($this->q,$this->link1,$xxx,$xxx,"name");

     $this->assign('xf', $_GET['xf']);
     $this->assign('xo', $_GET['xo']);

     # Menu      
     $x = team::getSelectLink($this->user,$lang['Search']);
     $this->addMenu($x);

     if ( $this->user->feature_ok(useteams,PERM_NEW) ) {
       $x = array('url'   => "team_new.php",
                  'text'  => $lang['NewEntry'],
                  'info'  => $lang['TeamCreateI'],
		  'image' => 'teams',
                  'category' => array("team","new","obj")
                 );
       $this->addMenu($x);
     }

     web_StackStartLayout($this, "team_overview.php",
			  "team_overview.php?".$_SERVER['QUERY_STRING']);

     $this->result = $this->dbconn->Exec($this->q);
     $n = $this->result->numrows();

     if ( 0 == $n) {
       $this->redirect = "team_select.php?msg=". UrlEncode($lang['Err0048']);
       $this->result->free();
     }
     else if ( ($this->format == "html") && ($this->result->numrows() == 1) ) {
       $b = new team($this->dbconn);
       $b->read_result($this->result,0);
       if ( $b->see_ok() ) {
         $this->redirect =  "team_show.php?id=".$b->id;
         $this->result->free();
       }
     }
   }
 }

 $l = new team_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: team_overview.php,v 1.46.2.3 2004/10/05 16:31:09 tapoueh Exp $
    $Author: tapoueh $
-->
