/* null plugin for Tux Commander
 * Copyright (C) 2005 Tomas Bzatek <tbzatek@users.sourceforge.net>
 *  Check for updates on tuxcmd.sourceforge.net
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <string.h>
#include <stdlib.h>
#include <stdint.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>
#include <time.h>
#include "vfs_types.h"


//  Declaration of the global plugin object
struct TVFSGlobs {
  TVFSLogFunc log_func;
  int list_item_id;
  char *curr_dir;
};



//  Basic initialization functions
int VFSAllocNeeded()
{
  return sizeof(struct TVFSGlobs);
}

void VFSInit(struct TVFSGlobs *globs, TVFSLogFunc log_func)
{

  globs->log_func = log_func;
  globs->log_func("null plugin: VFSInit");
  globs->curr_dir = NULL;
 
}

void VFSDestroy(struct TVFSGlobs *globs)
{

  globs->log_func("null plugin: VFSDestroy");

}

int VFSVersion()
{
  return cVFSVersion;
}

struct TVFSInfo VFSGetInfo()
{

  static const struct TVFSInfo info =
  {
     "Null plugin",
     "null testing plugin",
     "Plugin API version 2",
     "Copyright © 2007 Tomáš Bžatek"
  };

  return info;
}

char *VFSGetPrefix(struct TVFSGlobs *globs)
{
  return "null";
}

TVFSResult VFSOpen(struct TVFSGlobs *globs, char *sName)
{
 return cVFS_OK;
}

TVFSResult VFSClose(struct TVFSGlobs *globs)
{
 return cVFS_OK;
}

char *VFSGetPath(struct TVFSGlobs *globs)
{
  return globs->curr_dir;
}

u_int64_t VFSGetFileSystemFree(struct TVFSGlobs *globs, char *APath)
{
  return 0;
}

u_int64_t VFSGetFileSystemSize(struct TVFSGlobs *globs, char *APath)
{
  return 0;
}



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////

TVFSResult VFSChangeDir(struct TVFSGlobs *globs, char *NewPath)
{
  if (globs->curr_dir != NULL) free(globs->curr_dir);
  globs->curr_dir = strdup(NewPath);
  return cVFS_OK;
}

int VFSLogin(struct TVFSGlobs *globs, char *user, char *pass)
{
  return cVFS_OK;
}



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////

static char *items[] =
{
   "This is the first item",
   "This is the second item",
   "This is the third item",
   "This is the fourth item",
   "This is the fifth item",
   "This is the sixth item",
   "This is the seventh item",
   "This is the eight item",
   "This is the nineth item",
   "This is the tenth item",
   "This is the eleventh item",
   "This is the twelveth item",
   "This is the thirteenth item",
   "This is the fourteenth item",
   "This is the fifteenth item",
   "This is the sixteeth item",
   "This is the seventeenth item",
   "This is the eighteenth item",
};


TVFSResult VFSListFirst(struct TVFSGlobs *globs, char *sDir, struct TVFSItem *Item)
{
  globs->list_item_id = 0;
  printf("C Item = %lu \n", (long int)Item);

  Item->sFileName = strdup(items[globs->list_item_id]);
//  Item->iSize = rand();
  Item->iSize = globs->list_item_id + 1;
  Item->iMode = S_IRWXO + S_IRWXG + S_IRWXU;
  Item->sLinkTo = "/tmp";
  Item->ItemType = vSymlink;
  Item->iUID = 100;
  Item->iGID = 1000;
  Item->m_time = time(NULL) + globs->list_item_id;
  printf("C sizeof(TVFSItem) = %ld \n", sizeof(struct TVFSItem));
  printf("C sizeof(Item->sFileName) = %ld \n", sizeof(Item->sFileName));
  printf("C sizeof(Item->iSize) = %ld \n", sizeof(Item->iSize));
  printf("C sizeof(Item->m_time) = %ld \n", sizeof(Item->m_time));
  printf("C sizeof(Item->a_time) = %ld \n", sizeof(Item->a_time));
  printf("C sizeof(Item->c_time) = %ld \n", sizeof(Item->c_time));
  printf("C sizeof(Item->iMode) = %ld \n", sizeof(Item->iMode));
  printf("C sizeof(Item->sLinkTo) = %ld \n", sizeof(Item->sLinkTo));
  printf("C sizeof(Item->iUID) = %ld \n", sizeof(Item->iUID));
  printf("C sizeof(Item->iGID) = %ld \n", sizeof(Item->iGID));
  printf("C sizeof(Item->ItemType) = %ld \n", sizeof(Item->ItemType));

  static struct TVFSItem x;
  printf("C sizeof(x.sFileName) = %ld \n", sizeof(x.sFileName));
  printf("C sizeof(x.iSize) = %ld \n", sizeof(x.iSize));
  printf("C sizeof(x.m_time) = %ld \n", sizeof(x.m_time));
  printf("C sizeof(x.a_time) = %ld \n", sizeof(x.a_time));
  printf("C sizeof(x.c_time) = %ld \n", sizeof(x.c_time));
  printf("C sizeof(x.iMode) = %ld \n", sizeof(x.iMode));
  printf("C sizeof(x.sLinkTo) = %ld \n", sizeof(x.sLinkTo));
  printf("C sizeof(x.iUID) = %ld \n", sizeof(x.iUID));
  printf("C sizeof(x.iGID) = %ld \n", sizeof(x.iGID));
  printf("C sizeof(x.ItemType) = %ld \n", sizeof(x.ItemType));

  return cVFS_OK;
}

TVFSResult VFSListNext(struct TVFSGlobs *globs, char *sDir, struct TVFSItem *Item)
{
  globs->list_item_id++;
  printf("C Item = %lu \n", (long int)Item);

  if (globs->list_item_id >= (sizeof(items) / sizeof(items[0]))) {
   Item = NULL;
   return cVFS_No_More_Files;
  }

  Item->sFileName = strdup(items[globs->list_item_id]);

  Item->iSize = globs->list_item_id + 1;
  Item->iMode = S_IRWXO +  /* S_IRWXG + */ S_IRWXU;
  Item->sLinkTo = NULL;
  Item->iUID = 100;
  Item->iGID = 1000;
  Item->m_time = time(NULL) + globs->list_item_id;

  if (globs->list_item_id < 4) Item->ItemType = vDirectory;
  else Item->ItemType = vRegular;

  return cVFS_OK;
}

TVFSResult VFSListClose(struct TVFSGlobs *globs)
{
  return cVFS_OK;
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////
long VFSFileExists(struct TVFSGlobs *globs, const char *FileName, const long Use_lstat)
{
  return 0;
}

TVFSResult VFSFileInfo(struct TVFSGlobs *globs, char *AFileName, struct TVFSItem *Item)
{
  return cVFS_OK;
}

TVFSResult VFSMkDir(struct TVFSGlobs *globs, const char *sDirName)
{
  return cVFS_OK;
}

TVFSResult VFSRemove(struct TVFSGlobs *globs, const char *APath)
{
  return cVFS_OK;
}

TVFSResult VFSRename(struct TVFSGlobs *globs, const char *sSrcName, const char *sDstName)
{
  return cVFS_OK;
}

TVFSResult VFSMakeSymLink(struct TVFSGlobs *globs, const char *NewFileName, const char *PointTo)
{
  return cVFS_OK;
}

TVFSResult VFSChmod(struct TVFSGlobs *globs, const char *FileName, const uint Mode)
{
  return cVFS_OK;
}

TVFSResult VFSChown(struct TVFSGlobs *globs, const char *FileName, const uint UID, const uint GID)
{
  return cVFS_OK;
}

TVFSResult VFSChangeTimes(struct TVFSGlobs *globs, char *APath, long mtime, long atime)
{
  return cVFS_OK;
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////

u_int64_t VFSGetDirSize(struct TVFSGlobs *globs, char *APath)
{
  return 0;
}


void VFSBreakGetDirSize(struct TVFSGlobs *globs)
{

}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////

TVFSFileDes VFSOpenFile(struct TVFSGlobs *globs, const char *APath, int Mode, int *Error)
{
  *Error = 0;
  return (TVFSFileDes)0;
}

TVFSResult VFSCloseFile(struct TVFSGlobs *globs, TVFSFileDes FileDescriptor)
{
  return cVFS_OK;
}

u_int64_t VFSFileSeek(struct TVFSGlobs *globs, TVFSFileDes FileDescriptor, u_int64_t AbsoluteOffset, int *Error)
{
  *Error = 0;
  return 0;
}

int VFSReadFile(struct TVFSGlobs *globs, TVFSFileDes FileDescriptor, void *Buffer, int ABlockSize, int *Error)
{
  *Error = 0;
  return 0;
}

int VFSWriteFile(struct TVFSGlobs *globs, TVFSFileDes FileDescriptor, void *Buffer, int BytesCount, int *Error)
{
  *Error = 0;
  return 0;
}

void VFSSetBlockSize(struct TVFSGlobs *globs, int Value)
{

}

int VFSIsOnSameFS(struct TVFSGlobs *globs, const char *Path1, const char *Path2)
{
  return 0;
}

int VFSTwoSameFiles(struct TVFSGlobs *globs, const char *Path1, const char *Path2)
{
  return 0;
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////

TVFSResult VFSCopyOut(struct TVFSGlobs *globs, const char *sSrcName, const char *sDstName, TVFSCopyCallBackFunc pCallBackProgress, void *data, int Append)
{
  return cVFS_OK;
}

TVFSResult VFSCopyIn(struct TVFSGlobs *globs, const char *sSrcName, const char *sDstName, TVFSCopyCallBackFunc pCallBackProgress, void *data, int Append)
{
  return cVFS_OK;
}

////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////




