<?php


 // We need a few functions from the contacts feature to display the contact lists
 if( !$included["features/shared/contacts.inc.php3"] ) { include( "features/shared/contacts.inc.php3" ); }

 if( !isset( $ItemID ) && isset( $data["id"] ) ) { $ItemID = $data["id"]; }

 $i = 0;
 $menu[$i] = array( "command" => "meetings", "desc" => TWIGPhrase( "Back to Meetings" ), "action" => "main", "options" => "list=0", "target" => "", "image" => "registered.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => TWIGPhrase( "View details" ), "action" => "view", "options" => "ItemID=$ItemID", "target" => "", "image" => "public.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => TWIGPhrase( "Edit notes" ), "action" => "notes", "options" => "ItemID=$ItemID", "target" => "", "image" => "public.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => TWIGPhrase( "Edit todo" ), "action" => "todo", "options" => "ItemID=$ItemID", "target" => "", "image" => "public.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => TWIGPhrase( "Edit invitees" ), "action" => "invite", "options" => "ItemID=$ItemID", "target" => "", "image" => "public.gif" ); $i++;
 $menu[$i] = array( "command" => "meetings", "desc" => TWIGPhrase( "Reschedule" ), "action" => "edit", "options" => "ItemID=$ItemID", "target" => "", "image" => "private.gif" ); $i++;

 TWIGProcessLeftRightOptions( "invitees" );

 if( isset( $submitbutton["update"] ) )
	{ 
	// Get the old set of invitees
	$query = "SELECT * FROM " . $dbconfig["meetings_inv_table"] . " WHERE eventid ='" . $ItemID . "'";
	TWIGDebug( $query );
	$result = dbQuery( $query );
		
	// New ones to insert (on the right, but not in the db)
	// Old ones to delete (in the db, but not on the right)
	// Same ones to leave alone (in the db and on the right)

	// 1 - Eliminate the sames
	// 2 - Delete remaining db entries
	// 3 - Insert remaining array entries

	for( $i = 0, $j = dbNumRows( $result ); $i < $j; $i++ )
		{
		$oldinv = dbResultArray( $result, $i );

		if( isset( $invitees_orig_right[$oldinv["username"] . "_3"] ) || isset( $invitees_orig_right[$oldinv["username"] . "_2"] ) || isset( $invitees_orig_right[$oldinv["username"] . "_1"] ) )
			{
			if( isset( $invitees_orig_right[$oldinv["username"] . "_1"] ) )
				{
				unset( $invitees_orig_right[$oldinv["username"] . "_1"] );
				}
			if( isset( $invitees_orig_right[$oldinv["username"] . "_2"] ) )
				{
				unset( $invitees_orig_right[$oldinv["username"] . "_2"] );
				}
			if( isset( $invitees_orig_right[$oldinv["username"] . "_3"] ) )
				{
				unset( $invitees_orig_right[$oldinv["username"] . "_3"] );
				}
			}
		else
			{
			$delinv[] = $oldinv["username"];
			}
		}

	// Walk the db, and prepare a list of items to delete.
	if( is_array( $delinv ) )
		{
		$i = 0;
		reset( $delinv );
		while( list( $key, $val ) = each( $delinv ) )
			{
			if( $i == 0 )
				{
				$delinvs = "username = '" . $val . "'";
				}
			else
				{
				$delinvs .= " OR username = '" . $val . "'";
				}
			$i++;
			}
		$query = "DELETE FROM " . $dbconfig["meetings_inv_table"] . " WHERE eventid='" . $data["id"] . "' AND (" . $delinvs . ")";
		TWIGDebug( $query );
		$result = dbQuery( $query );
		}

	// Walk the right, and prepare a list of items to insert.
	if( is_array( $invitees_orig_right ) )
		{
		reset( $invitees_orig_right );
		while( list( $key, $val ) = each( $invitees_orig_right ) )
			{
			$query = "INSERT INTO " . $dbconfig["meetings_inv_table"] . " (username, eventid) VALUES ('" . substr( $key, 0, strlen( $key ) - 2 ) . "', '" . $data["id"] . "')";
			TWIGDebug( $query );
			$result = dbQuery( $query );
			}
		}
	}

 if( !isset( $invitees_left ) && !isset( $invitees_right ) )
        {
 	$query = "SELECT groupid FROM " . $dbconfig["meetings_table"] . " WHERE id = '" . $ItemID . "'";
 	$result = dbQuery( $query );
 	if( dbNumRows( $result ) > 0 )
 		{
		$groupid = dbResultArray( $result, 0 );
		$groupid = $groupid["groupid"];
		}

	$sortorder = array( "name"=>"lastname,firstname", "company"=>"company", "group"=>"groupid", "email"=>"email" );
 	$orderby = $sortorder[GetPref( "sortby", $dbconfig["contacts_prefs_table"], $config["defaults"]["contacts"]["sortby"] )];
 	if( !$orderby ) { $orderby = $sortorder["name"]; }

	// Get the mycontact of the group's owner
	$query0 = "select g.owner, g.id, c.username, c.firstname, c.lastname, c.email, c.email2, c.email3 from " . $dbconfig["contact_table"] . " as c, " . $dbconfig["groups_table"] . " as g where c.username = g.owner AND c.userpers = '1' AND g.id = '" . $groupid . "' ORDER BY " . $orderby;
	// Get the mycontact of the group's members
	$query1 = "select m.username, m.groupid, c.username, c.firstname, c.lastname, c.email, c.email2, c.email3 from " . $dbconfig["contact_table"] . " as c, " . $dbconfig["members_table"] . " as m where c.username = m.username AND c.userpers = '1' AND m.groupid = '" . $groupid . "' ORDER BY " . $orderby;
	// Get the mycontact of those who have already been invited,
	// even though they aren't in the group (the group might have been changed at some point).
	// There's no need to worry about selecting the same username in more than one
	// of these queries, because the array is indexed by username, and so each user
	// can be listed only once; trying to list him again just "overwrites" the first entry.
	$query2 = "select r.username, c.username, c.firstname, c.lastname, c.email, c.email2, c.email3 from " . $dbconfig["contact_table"] . " as c, " . $dbconfig["meetings_inv_table"] . " as r where c.username = r.username AND c.userpers = '1' ORDER BY " . $orderby;
	// Do this thrice, to get group owner, members and non-group people already involved
	for( $q = 0; $q < 3; $q++ )
		{
		// Yeah, this is pretty hackish...
		$query = "query$q";
		TWIGDebug( $$query );
		$result = dbQuery( $$query );

		for( $i = 0, $j = dbNumRows( $result ); $i < $j; $i++ )
			{
			$groupdata = dbResultArray( $result, $i );
        
			$personal = trim( $groupdata["firstname"] . " " . $groupdata["lastname"] );
			if( $groupdata["email"]  )
				{
				if( $personal )
					{
					$label = "&quot;" . $personal . "&quot; ";
					}
				else
					{
					unset( $label );
					}
				$label .= "&lt;" . $groupdata["email"]  . "&gt;";
				$invitees_left[$groupdata["username"] . "_1"] = $label;
				}
			if( $groupdata["email2"] )
				{
				if( $personal )
					{
					$label = "&quot;" . $personal . "&quot; ";
					}
				else
					{
					unset( $label );
					}
				$label .= "&lt;" . $groupdata["email2"]  . "&gt;";
				$invitees_left[$groupdata["username"] . "_2"] = $label;
				}
			if( $groupdata["email3"] )
				{
				if( $personal )
					{
					$label = "&quot;" . $personal . "&quot; ";
					}
				else
					{
					unset( $label );
					}
				$label .= "&lt;" . $groupdata["email3"]  . "&gt;";
				$invitees_left[$groupdata["username"] . "_3"] = $label;
				}
			}
		}

	$query = "SELECT * FROM " . $dbconfig["meetings_inv_table"] . " WHERE eventid ='" . $ItemID . "'";
	TWIGDebug( $query );
	$result = dbQuery( $query );
		
	// We have already invited some people.
	// Figure out who they are, and show them as invited.
	for( $i = 0, $j = dbNumRows( $result ); $i < $j; $i++ )
		{
		$listdata = dbResultArray( $result, $i );

		if( $listdata["type"] == 2 )
			{
			}
		else
			{
			if( isset( $invitees_left[$listdata["username"] . "_1"] ) )
				{
				$invitees_right[$listdata["username"] . "_1"] = $invitees_left[$listdata["username"] . "_1"];
				unset( $invitees_left[$listdata["username"] . "_1"] );
				}
			if( isset( $invitees_left[$listdata["username"] . "_2"] ) )
				{
				$invitees_right[$listdata["username"] . "_2"] = $invitees_left[$listdata["username"] . "_2"];
				unset( $invitees_left[$listdata["username"] . "_2"] );
				}
			if( isset( $invitees_left[$listdata["username"] . "_3"] ) )
				{
				$invitees_right[$listdata["username"] . "_3"] = $invitees_left[$listdata["username"] . "_3"];
				unset( $invitees_left[$listdata["username"] . "_3"] );
				}
			}
		}
	}


 $ret = TWIGListItemEditProcess(  "edit", $dbconfig["meetings_table"], $groupquery, $data );
 if( $ret != FALSE && $ret != TRUE )
 	{
 	TWIGPrintError( $ret );
 	}

 $data = TWIGListGetItem( $ItemID, $dbconfig["meeting_table"], "*", $GroupQuery);
 echo TWIGListItemHeader( $data, "edit", $menu );

// TWIGListItemEditProcess assumes that groupid will be passed
// if it is not, the groupid is reset to 0 (unfiled)
// So we just have to make sure to pass it along to the next page load
?>
<INPUT TYPE="hidden" NAME="data[groupid]" VALUE="<?php echo $data["groupid"]; ?>">

<TABLE BORDER=0 CELLSPACING=0 cellpadding=0 class="formbody">
 <tr>
  <td colspan=3 class="tabletitlesmall">
   <table width="100%" BORDER=0 CELLSPACING=0 cellpadding=0><tr><td class="tabletitlelarge">
   <?php 
     echo TWIGPhrase( "Edit Meeting Invitees" );
   ?>
   </td><td align="right">
   <?php echo TWIGPhrase( "Added by: %1",  array( TWIGMailto( $data["username"] ) ) ); ?>
   </td></tr></table>
  </td>
 </tr>
 <tr><td colspan=3 class="formbody"><table border=0 cellspacing=0 cellpadding="5">
  <TR>
    <TD COLSPAN=2 valign="top">
      <b><?php echo TWIGPhrase( "Meeting Name" ); ?></b>:<br>
      <?php echo TWIGmassage( $data["item"] ); ?>
    </TD>
  </TR>
<?php
// Tags were broken with a - between <> and ?. Remove to enable. 
//  <TR>
//    <TD BGCOLOR="<-?php echo $config["cellcolor"]; ?->" COLSPAN="1">
//      <font face=<-?php echo $config["cellfont"]?-> size=<-?php echo $config["textfontsize"];?-> color=<-?php echo $fontcolor?->><b><-?php echo TWIGPhrase( "Type" ); ?-></b>:<br>
//      <-?php echo TWIGmassage( $data["type"] ); ?->
//    </TD>
//    <TD BGCOLOR="<-?php echo $config["cellcolor"]; ?->" COLSPAN="1">
//      <font face=<-?php echo $config["cellfont"]?-> size=<-?php echo $config["textfontsize"];?-> color=<-?php echo $fontcolor?->><b><-?php echo TWIGPhrase( "Location" ); ?-></b>:<br>
//      <-?php echo TWIGmassage( $data["location"] ); ?->
//    </TD>
//  </TR>
?>
  <TR>
    <TD valign="top">
      <b><?php echo TWIGPhrase( "Starting Time" ); ?></b>:<br>
      <?php echo date( TWIGGetTimeFormat(), convertSQLTimetoUTime( $data["itemstart"] )); ?> on<BR>
      <?php echo date( $config["longdateformat"], convertSQLTimetoUTime( $data["itemstart"] )); ?>
    </TD>
    <TD valign="top">
      <b><?php echo TWIGPhrase( "Ending Time" ); ?></b>:<br>
      <?php echo date( TWIGGetTimeFormat(), convertSQLTimetoUTime( $data["itemstop"] )); ?> on<BR>
      <?php echo date( $config["longdateformat"], convertSQLTimetoUTime( $data["itemstop"] )); ?>
    </TD>
  </TR>
  <TR>
    <TD valign="top">
      <b><?php echo TWIGPhrase( "Initiator" ); ?></b>:<br>
      <?php echo $data["username"]; ?>
    </TD>
    <TD valign="top">
      <b><?php echo TWIGPhrase( "Secretary" ); ?></b>:<br>
      <?php echo $data["secretary"]; ?>
    </TD>
  </TR>
  <TR>
    <TD  valign="top">
      <b><?php echo TWIGPhrase( "User Limit" ); ?></b>:<br>
      <?php echo $data["userlimit"]; ?>
    </TD>
    <TD  valign="top">
      <b><?php echo TWIGPhrase( "Last Modified" ); ?></b>:<br>
      <?php echo date( $config["longdateformat"], convertSQLTimetoUTime( $data["thedate"] )); ?>
    </TD>
  </TR>
 </table></td></tr>
 <tr>
  <td colspan=3>
   <?php echo TWIGGenerateLeftRightOptions( $invitees_left, $invitees_right, "invitees", TWIGPhrase( "Contacts" ), TWIGPhrase( "Invitees" ), "10" ); ?>
  </td>
 </tr>
</table>

<?php
 if( TWIGGroupsMemberOf( $data["groupid"], 2 ) )
 	{
	$buttons = "<input type=submit name=submitbutton[update] value=\"" . TWIGPhrase( "Update" ) . "\">\n";
	}
 echo TWIGListItemFooter( $data, "edit", $buttons );
?>

