#!/usr/bin/php
<?php

//  -- Configuration --

$basedir = "/var/www/html/";
$runfrequency = 15; // ---- This is how often the script is run (Default: every 15 minutes)

// ---------------------

require( $basedir . "config/config.inc.php3" );	// Global Configuration Variables
global $config;
require( $basedir . "config/dbconfig.inc.php3" );
if( !$dbconfig["sqltype"] ) { $dbconfig["sqltype"] = "mysql"; }
require( $basedir . "/lib/db/" . $dbconfig["sqltype"] . ".db.inc.php3" );
if( !$config["imap_servertype"] ) { $config["imap_servertype"] = "php-imap"; }

require( $basedir . "lib/mail/" . $config["imap_servertype"] . ".inc.php3" );	// include the mail subsystem
require( $basedir . "features/shared/prefs.inc.php3" );
require( $basedir . "features/common.inc.php3" );					// include common functions...
require( $basedir . "features/mail/mail.inc.php3" );					// include mail functions...
require( $basedir . "lib/mail/send." . $config["mail_sender"] . ".inc.php3" );
require( $basedir . "features/schedule/reminders.inc.php3" );

$query = "SELECT * FROM " . $dbconfig["schedule_table"] . " WHERE (remind_time > '0')";
$result = dbQuery( $query );

for( $i = 0, $j = dbNumRows( $result ); $i < $j; $i++ )
	{
	$item = dbResultArray( $result, $i );
	$login["username"] = $item["username"];

	$to = "";
	$fromaddr = "";
	$mailheaders = "";
	$bodytext = "";

	// Find out what the preferred language is...
	$config["language"] = GetPref( "language", $dbconfig["global_prefs_table"], $config["defaults"]["global"]["language"] );
	// ...then load the current feature's language strings and the global language strings
	TWIGLoadLanguageFile( $basedir . "features/schedule/strings/", "", $config["language"] );
	//TWIGLoadLanguageFile( $basedir . "lib/strings/", "", $config["language"] );

	$startDate = convertSQLTimetoUTime( $item["itemstart"] );
	$endDate = convertSQLTimetoUTime( $item["itemstop"] );
	$mailalert = GetPref( "refresh", $dbconfig["global_prefs_table"], $config["defaults"]["global"]["refresh"] ); // if the system has the mail alert add-on installed
	$currenttime=time ();
	$alerttime = convertSQLTimetoUTime( $item["remind_time"] );
	$startDay = date( "j", $alerttime );
	$startMonth = date( "n", $alerttime );
	$startYear = date( "Y", $alerttime );
	$startHour = date( "H", $alerttime );
	$startMinute = date( "i", $alerttime );
	$buffer = max ( ($mailalert * 60),  ($runfrequency * 60) );

	if ( ($currenttime + $buffer) >= $alerttime )
		{
		$to = $login["username"] . "@" . $config["fromdomain"];
		$fromaddr = "TWIG.". TWIGphrase("Schedule") . "@" . $config["fromdomain"];
		$mailheaders .= "Date: " . TWIGGenerateMailDate() . "\r\n";
		$mailheaders .= "To: " . $to . "\r\n";
		if ( $item["remind_address"] )
			{
			$mailheaders .= "Cc: " . $item["remind_address"] . "\r\n";
			}
		$mailheaders .= "Subject: " . TWIGphrase("*** REMINDER ***") . "\r\n";
		$mailheaders .= "Return-Path: " . $fromaddr . "\r\n";
		$mailheaders .= "From: TWIG ". TWIGphrase("Schedule") . " <" . $fromaddr . ">\r\n";
		$mailheaders .= "X-Mailer: TWIG\r\n";
		$mailheaders .= "MIME-Version: 1.0\r\n";

		switch ( $item["remind_units"] )
			{
			case "1": // Minutes
				$current_occurance = mktime($startHour,$startMinute+$item["remind_qty"],0,$startMonth,$startDay,$startYear);
				break;
			case "2": // Hours
				$current_occurance = mktime($startHour+$item["remind_qty"],$startMinute,0,$startMonth,$startDay,$startYear);
				break;
			case "3": // Days
				$current_occurance = mktime($startHour,$startMinute,0,$startMonth,$startDay+$item["remind_qty"],$startYear);
				break;
			case "4": // Weeks
				$current_occurance = mktime($startHour,$startMinute,0,$startMonth,$startDay+($item["remind_qty"]*7),$startYear);
				break;
			case "5": // Months
				$current_occurance = mktime($startHour,$startMinute,0,$startMonth+$item["remind_qty"],$startDay,$startYear);
				break;
			case "6": // Years
				$current_occurance = mktime($startHour,$startMinute,0,$startMonth,$startDay,$startYear+$item["remind_qty"]);
				break;
			}

		$bodytext .= TWIGphrase("This is a reminder for ");
		$bodytext .= $item["item"] . " " . TWIGphrase("on") . " " . strftime( '%D', $current_occurance ) . " " . TWIGphrase("at") . " " . strftime( '%r', $startDate ) . "\n\n";
		if ( $item["description"] )
			{
			$bodytext .= TWIGphrase("Description") . ":\n";
			$bodytext .= $item["description"] . "\n";
			}
		$next_reminder = 0;

		if ( $item["recurtype"] ) // ---------- If the scheduled item is recurring
			{
			$query2 = "SELECT * FROM " . $dbconfig["schedule_recurring_table"] . " WHERE (id = '" . $item["recurid"] . "')";
			$result2 = dbQuery( $query2 );
			$rddata = dbResultArray( $result2,0 );
			if ( !$rddata["schedule"] )
				{
				$rddata["schedule"] = 1;
				}
			$next_occurance = getNextOccurance ( $item, $rddata, $current_occurance );
			if ( $next_occurance )
				{
				$next_reminder = getNextReminder ( $next_occurance, $item );
				$bodytext .= "\n" . TWIGphrase("This is a recurring entry and you will be reminded again on ") . strftime( '%D', $next_reminder ) . ".\n";
				}
			}

		$ret = TWIGMailSendMessage( $config["smtp_server"], $config["smtp_port"], $to, $fromaddr, $config["fromdomain"], $mailheaders, $bodytext );
		//echo $bodytext . "\n\n"; //----------------------------------------------------------------------For testing----------------------------------------------------------
		$query3 = "UPDATE " . $dbconfig["schedule_table"] . " SET itemstart=itemstart, itemstop=itemstop, thedate=thedate, remind_time='" . convertUTimeToSQLTime ( $next_reminder ) . "' WHERE id = '" . $item["id"] . "'";
		$result3 = dbQuery( $query3 );
		}
	}
?>