/*
 * Header file for TWLOG Help
 */

#define NUM_TOPICS 10
char *helpTopics[NUM_TOPICS] = {
   "About",
   "Introduction",
   "Menu Bar",
   "Help Windows",
   "Log Entry Form",
   "Call Sign Search",
   "Log Editor",
   "Resources",
   "Limits",
   "Keyboard"
};

char *helpText[NUM_TOPICS] = {
   "About - not used",

/***** INTRODUCTION SECTION *****/

   "\n\
Twlog uses simple data entry forms to collect, save, and edit basic data \
for an amateur radio operator's log.  It records ten pieces of information \
- six of which can be entered with a button or key press.  The ten pieces \
of data are the Date and Start Time of the QSO, the Call of the station \
worked, Band, Mode, Power, Signal Reports exchanged and End Time.  A Notes \
field is also available for any additional comments you may wish to include.\n\
\n\
The Band, Mode, and Power menu options, and many other properties of the \
program, can be configured to meet your operating needs and preferences.  \
These resources are read from a text file when twlog starts, so you do not \
need to recompile the program if you change the settings.  See the Resource \
section for more information.\n\
\n\
Twlog has the following windows:\n\
     Main window with a Menu Bar and Log Entry Form\n\
     Call Search window\n\
     Log Editor\n\
     About dialog\n\
     Help windows\n\
\n\
\n\
73,\n\
Ted - WA\330EIR",

/***** MENU BAR SECTION *****/

   "\n\
The Menu Bar has three buttons  -  File, Edit and Help.  Clicking on one of \
these buttons produces a drop down menu.  The functions of the buttons in \
the drop down menus are described below. \n\
\n\
All three drop down menus have a dashed line on top.  This is the \
\"tear off\" button.  Selecting the \"tear off\" will create a new window that \
contains all the buttons in the drop down menu.  This can be handy, when you \
need to frequently use the buttons in a drop down menu. \n\
\n\
For example, click on the Help button, and then the dashed line.  You will \
now have a window with all of the Help topics.  Click on the Introduction \
button, and the Introduction text will be displayed.  Clicking on another \
Help topic will display that topic's text. \n\
\n\
All of the drop down buttons have mneumonic and accelerator keys.  These \
allow you to select a button without using the mouse.  See the Keyboard \
section for more information. \n\
\n\n\
File Button\n\
The menu bar's File button displays the following choices:\n\
\n\
Print Log Button\n\
This button queues your logfile for printing to your default printer.  You \
can continue to log contacts while the file is printing, but the new contacts \
will not be printed.\n\
\n\
New Log Button\n\
Selecting this option will rename your current logfile and create a new, \
empty logfile.  The current logfile's name will be changed to:\n\
\n\
log.yyyy.ddd.hhmmss  -  where:\n\
\n\
yyyy	= this year\n\
ddd	= the day of this year (1 Jan = 001, 31 Dec = 365 or 366)\n\
hhmmss	= hour, minute, and second when the file was created.\n\
\n\
This naming convention will allow you to combine several logs with - \n\
cat log.* > biglog\n\
and everything will be in the correct order.\n\
\n\
Convert Button\n\
This button pops up a dialog that allows you to convert logfiles between\n\
adif and twlog formats.  In the dialog box, you select the file format of\n\
the Output file, twlog or adif.  Also, there are two text boxes where you\n\
specify the Input and Output files.  You can use the Browse buttons to\n\
select the files but, if the Output file does not exist, then you will have\n\
to enter a new file name in the Output File: text box.\n\
\n\
QRT Button\n\
Exit the program.\n\
\n\
Edit Button\n\
The menu bar's Edit button displays the following choices:\n\
\n\
Append Button\n\
You use this button to record a QSO. Clicking on it will cause all of the \
data in the right column of the log entry form to be appended to your \
logfile. It then clears the form.\n\
\n\
Clear Form Button\n\
This button simply clears all the fields in the log entry form. \
It is just an easy way to erase text you may have entered and \
do not want to save to the log file.\n\
\n\
Edit Log Button\n\
Pressing this button creates the Edit dialog window and displays \
the contents of your logfile.  See the Log Editor section for more \
information.\n\
\n\
Help Button\n\
The menu bar's Help button displays the following choices:\n\
\n\
About Button\n\
This pops up the About Dialog which displays a little bit about \
who wrote this thing.\n\
\n\
Help Topic Buttons\n\
The remainimg buttons in the Help pull down are: \n\
Introduction, Menu Bar, Help Windows, Log Entry Form,\n\
Log Editor, Resource, Limits, and Keyboard\n\
\n\
See the Help Windows section for more information.",

/***** HELP WINDOWS SECTION *****/

   "\n\
The Help window is opened by selecting one of the buttons, other than the \
About button, under the Main Menu bar's Help button.  The label on the \
top of the Help window shows which section is being displayed.  The Help \
window has three buttons - Find, Find Again, and Clear.\n\
\n\
Find Button\n\
This button pops up a window where you type the text string that \
you want to find.  Buttons on this window allow you to perform the search \
the current section or all of the Help sections.  After pushing one of \
these buttons, the Help will be searched, and if it is found, the window \
will scroll to the matching text and hightlight it. \n\
\n\
NOTE:  This search is not case sensitive. \n\
\n\
You can now press the Find button to start over with a new search string. \n\
\n\
Find Again Button\n\
Once your string has been found, the Find Again button becomes active.  You \
use this to find the next match. If the search reaches the end of the \
section without finding your string, a \"String Not Found\" message will \
be displayed.  The String Not Found message will also be displayed after \
all sections have been searched if searching all sections.\n\
",

/***** LOG ENTRY FORM SECTION *****/

   "\n\
The log entry form in the Main window consists of ten rows of two \
columns.  The left column has push buttons and labels, and the \
right column contains text fields or option menus.\n\
\n\
The right column contains the values that will be written to the \
logfile.  Nothing is written to the logfile until you press the \
Append button, so you may edit these columns at any time. \n\
\n\
See the Limits section for information about field lengths \n\
\n\
Date: \n\
This row consists of a push button on the left and a text field on \
the right.  Pushing this button will fill the text field with the \
current date. \n\
\n\
Start Time: \n\
Push this button to fill the Start Time text field.  It also fills \
the Date text field with the current date, so both the Date and \
Start Time can be entered with this one button press. \n\
\n\
Call: \n\
Click the box on the right hand side.  A border will be placed around \
the text field and a cursor will be displayed.   Now type in the call \
sign of the station you are working.  NOTE: All letters are changed \
to upper case automatically, so no need for the shift key. \n\
\n\
You can also use this field to search your log file for a call sign.  \
See the Call Search section for more information.\n\
\n\
Band: \n\
The right column of the Band row is an option menu.  Clicking on \
the menu will display a list of bands or frequencies you have selected. \
Then click on the desired band/frequency.  The menu will show the \
selected frequency or band. \n\
\n\
Mode: \n\
This is another option menu.  Click on the menu and select your mode, \
just like the Band menu above. \n\
\n\
Power: \n\
Click on this option menu to select your power, just like the Band \
menu above. \n\
\n\
His RST: \n\
Click on the text field in the right column and type his signal report. \n\
\n\
My RST: \n\
Click on the text field in the right column and type your signal report. \n\
\n\
Notes: \n\
Click the box in the right column and type any notes or comments. \
This field is one long line of text.  As you type, the text will scroll \
to the left, making room for more text. \n\
\n\
End Time: \n\
Push this button to fill in the current time, just like the Start Time \
button. \n\
",

/***** CALL SEARCH SECTION *****/

   "\n\
Twlog automatically performs a call search on your log file.  When \
you type a call in the Main window and hit Enter or Tab, a search is \
done, and the Call Search window will pop up, showing all of the contacts \
with that station. \n\
\n\
You can also search for a call or partial call at any time.  Type \
at least two characters into the Call field, and hit Enter or Tab.  The \
Call Search window will show all log entries with those characters in \
the Call field.  You can then use the Clear Form button under the Edit \
button (or Crtl-C) to clear the form. \n\
\n\
To search for a text string in all of the fields of your log, use the \
Search feature in the Log Editor.  \n\
",

/***** LOG EDITOR SECTION *****/

   "\n\
The Log Editor is a spread sheet like window with three push buttons. \
It allows you to edit and search the contents of your logfile.  Editing \
and Searching with this window are described below.\n\
\n\
NOTE: While this window is open, you will NOT be able to use the Main \
window.  You must click the OK button to close this window before \
you can use the Main window. \n\
\n\
\n\
Editing\n\
In the editor you can change the fields in your log.  After you \
change a data field, you must move out of the field (tab or arrow button) \
before the Save button becomes active.  That's just the way the Xbae \
matrix widget works. \n\
\n\
NOTE:  Nothing is written to the logfile until you push the Save button.  So, \
you may exit at anytime WITHOUT saving the changes by pressing the OK \
button. \n\
\n\
Searching\n\
To search the logfile, type the search string into the Search Text window. \
Then hit Enter or click the Search button.  If a match is found, it is \
displayed as highlighted text.  You can then hit Enter or the Search button \
again to search for the next match.  If no match is found, the Search Text \
is cleared, and the Search button becomes desensitised.\n\
\n\
NOTE: This search is case sensitive\n\
",

/***** RESOURCE SECTION *****/

   "\n\
The resource file, Twlog, is an important part of this program.  It allows \
you to customize the program to meet your needs WITHOUT recompiling.  After \
making any changes to the resource file, you must restart the program to  \
have the changes take affect. \n\
\n\
A quick look at the file will tell you that a line beginning with an \
exclamation point (!) is a comment.  Lines in a resource file can become \
quite complex, but here we will look at just the basic rules. \n\
\n\
A line in the file contains two columns.  The left column is the name \
of a widget and one of its properties, like height or width.  The name is \
followed by a colon (:) and any number of spaces or tabs.  The right column \
is the value to be assigned to the property.  It is important that no spaces \
follow the value!  For example, if the right hand value were tan followed by \
a space, you would get an error message like this:  \n\
\n\
Warning: Color name \"tan \" is not defined \n\
\n\
The dumb computer is looking for a four letter word.  Notice it says it can't \
find \"tan \" - that's t, a, n, and a space - not just \"tan\".   \n\
\n\
If you want to create your own color scheme, change one of the colors to \
red, and restart the program.  Now you can see the parts of the interface \
controlled by that property.  Be sure to look at the Edit and Help windows \
to see if your change affected these windows. You can then change this  \
property to any color or rgb value (#rrggbb) you want, and then repeat this \
process for the other color properties.    \n\
\n\
This resource file is pretty straight forward.  The file is divided into \
the following sections. \n\
\n\
\n\
PROPERTIES - This section lets you define some basic properties for the  \
windows.  The lines with \"twlog.x:  0\" and \"twlog.y:  0\" allow you to \
position the upper, left hand corner of the MAIN window.  Change the 0's to \
the position you want the window to appear when the program starts. \n\
\n\
NOTE: When moving a window, some window managers display the current \
x-y position, and you can use these to determine the x-y values.  \n\
\n\
The next few lines determines the font that will be used in all the window \
of the interface. Variable and fixed are two sample choices here. \n\
\n\
TIME ZONE CHOICE - You can choose to record QSO times in local or GMT. \
Setting the property to 0 will record local time and 1 will record in GMT. \
Any other value will be detected as an error, and the program will exit. \n\
\n\
BANDS DATA - This property lets you select which bands or frequencies \
you want as options in the BANDS menu.  The right-hand value is a list of \
bands or frequencies, separated by commas. For example, \n\
twlog.bands:    80,40,30,20,15,10 \n\
\n\
DEFAULT BAND - This property allows you to select which band you want \
displayed when the program starts.  The right-hand column is a digit that  \
represents the default button in the BANDS DATA above.  NOTE: The numbering \
starts from zero.  So, if twlog.bands is 80,40,30,20 and your favorite band \
is 30 meters, you would make the DEFAULT BAND entry look like this: \n\
\n\
twlog.default_band:  2 \n\
\n\
MODES DATA - This value is set using the same rules as BANDS above.  Putting \
your favorite mode first in the list will make it the default value for \
the menu, or you can put then in the order you like and use the next  \
property to select the start up value. \n\
\n\
DEFAULT MODE - This one works the same as DEFAULT BAND. See DEFAULT BAND \
above. \n\
\n\
POWER DATA - This is another comma separated list just like BANDS and MODES. \
Again, make the first entry your most used power to get the proper default, \
or put them in order and use the next property to select the default. \n\
\n\
DEFAULT POWER - This one works the same as DEFAULT BAND. See DEFAULT BAND \
above. \n\
\n\
COLORS AND OSF CONTROLKEYS - In the PROPERTIES section above, the foreground \
and background colors were set to black and tan.  In this section some parts \
of the interface are set to other colors - a green (#00768d) and antiquewhite. \
These definitions override the earlier ones because they are more specific. \
They specify a widget (rc1) or a type of widget (XmLabel) instead of using  \
an \"*\" to match any widget.  The rule here is a more specific definition  \
wins. \n\
\n\
The last part of this section makes the control and function keys work as  \
I like them too.  You may be able to comment them all out.  It depends a  \
lot on what window manager you are using and how the keys are defined for \
your window manager.",

/***** LIMITS SECTION *****/

   "\n\
The number of characters that can be entered in a text field of the Main \
window and the log editor are: \n\
\n\
QSO #\t5 \n\
Date\t11 \n\
Start\t9 \n\
Call\t10 \n\
Band\t10 \n\
Mode\t8 \n\
Power\t8 \n\
His RST\t8 \n\
My RST\t8 \n\
End\t9 \n\
Notes\t80 ",

/***** KEYBOARD SECTION *****/

   "\n\
If you prefer, all operations can be done using the keyboard instead of the \
mouse.  This can be very efficient, since you don't have to move your hand \
between the keyboard and the mouse. \n\
\n\
When the program starts, the Date pushbutton is selected, as indicated by \
the border around it.  Pressing the Tab key will move the border and select \
another widget.  Shift Tab will move backwords through the widgets.  Hit tab \
several times and notice the sequence in which the widgets are selected.  The \
program may override this sequence in some cases.  See below. \n\
\n\
If a button is selected, pressing the space bar is the same as clicking on it \
with the mouse.  If the Band, Mode, or Power menu is selected, pushing the \
space bar will display the options.  Use the up and down arrows to select \
the option you want, and press the space bar.  Then the Tab will move you \
to the next widget. \n\
\n\
When a textfield is selected, type the data and press the Tab or Enter \
key to move to the next widget. \n\
\n\
The program overrides the normal sequence of the Tab key.  For example, if \
the Date button is selected and you press the space bar, the date textfield \
is filled in, and the program skips the Date textfield and goes to the Start \
Time pushbutton.  Right where you want to be anyway! \n\
\n\
The Menu bar can also be used via the keyboard.  If your window manager is \
behaving right, pressing F10 will display a 3D border around the File button \
in the Menu bar.  You can then use the left and right arrows to select a \
button in the Menu bar.  Press the space bar to display the options and use \
the up and down arrows to select an option and press the space bar.   \n\
\n\
There are also some shortcut keystrokes available.  Notice that some of the \
buttons in the Menu bar and drop down menus have an underlined character.  \
These buttons can be pushed by typing the underlined character, however the \
button must be displayed before this will work.  For example entering \
F10 H A will select the Menu bar (F10), then the Help button (H), and finally \
the About button (A). \n\
\n\
Another form of shortcuts is also available.  This kind does NOT require \
that the menu be displayed.  Click on the File button on the Menu bar and \
notice the text strings on the right side of the drop down menu.  Next to \
the Append button, is the text Ctrl-A.  This means that this option may \
be selected by a Control A keystroke.  Therefore, after you have filled \
in all of the info for a QSO, pressing Control A will append the info \
to your logfile."
};
