#!/bin/bash -e
#with this script we want to build the eclipse jars (bundles) used by tycho
#FIXME I realized later that sources are available. See
#http://central.maven.org/maven2/org/eclipse/tycho/org.eclipse.osgi.compatibility.state/1.0.100.v20150402-1551/org.eclipse.osgi.compatibility.state-1.0.100.v20150402-1551-sources.jar
#http://central.maven.org/maven2/org/eclipse/tycho/org.eclipse.jdt.compiler.apt/1.2.0.v20150514-0146/org.eclipse.jdt.compiler.apt-1.2.0.v20150514-0146-sources.jar
#FIXME libequinox-osgi-java ?

BUNDLES="./eclipse-bundles"

BUILD1=$1/org.eclipse.osgi
BUILD2=$1/org.eclipse.jdt.core
BUILD3=$1/org.eclipse.osgi.compatibility.state
BUILD4=$1/org.eclipse.jdt.compiler.apt

cd $BUNDLES

echo "Rearranging eclipse bundles..."

#==========first artifact=================================================================
mkdir -p $BUILD1/src/main/java

cp -r org.eclipse.core.runtime/src/* $BUILD1/src/main/java
cp -r org.eclipse.core.contenttype/src/* $BUILD1/src/main/java
cp -r org.eclipse.core.jobs/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.core/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.metadata/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.publisher/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.publisher.eclipse/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.repository/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.metadata.repository/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.artifact.repository/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.jarprocessor/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.simpleconfigurator/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.simpleconfigurator.manipulator/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.frameworkadmin/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.frameworkadmin.equinox/src/* $BUILD1/src/main/java
cp -r org.eclipse.osgi.util/src/* $BUILD1/src/main/java
cp -r org.eclipse.osgi/container/src/* $BUILD1/src/main/java
cp -r org.eclipse.osgi/supplement/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.preferences/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.preferences/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.common/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.security/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.app/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.registry/src/* $BUILD1/src/main/java

#cp -r org.eclipse.osgi.compatibility.state/src/* $BUILD1/src/main/java	#compat. include osgi.internal...
cp -r org.eclipse.osgi/felix/src/* $BUILD1/src/main/java

cp -r org.eclipse.equinox.p2.repository.tools/src/* $BUILD1/src/main/java
cp -r org.eclipse.osgi/osgi/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.app/osgi/* $BUILD1/src/main/java
cp -r org.eclipse.osgi.services/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.director/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.engine/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.jarprocessor/src_ant/* $BUILD1/src/main/java

#need SteppedTimeoutLexicoHelper from sat4j 2.3.4

cp -r org.eclipse.equinox.p2.touchpoint.eclipse/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.garbagecollector/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.updatesite/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.p2.director.app/src/* $BUILD1/src/main/java
cp -r org.eclipse.core.net/src/* $BUILD1/src/main/java

cp -r org.eclipse.swt/Eclipse\ SWT/common/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT/cairo/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT/gtk/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT/emulated/taskbar/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT/emulated/bidi/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT/emulated/coolbar/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT/common_j2se/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Custom\ Widgets/common/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Printing/common/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Printing/gtk/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Drag\ and\ Drop/common/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Drag\ and\ Drop/gtk/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ PI/common/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ PI/common_j2se/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ PI/cairo/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ PI/gtk/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Accessibility/common/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Accessibility/gtk/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Browser/common/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Browser/gtk/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Mozilla/common/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Mozilla/gtk/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ WebKit/gtk/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Program/common/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Program/gtk/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Program/gnome/* $BUILD1/src/main/java
cp -r org.eclipse.swt/Eclipse\ SWT\ Program/cde/* $BUILD1/src/main/java

cp -r org.eclipse.text/src/* $BUILD1/src/main/java
cp -r org.eclipse.text/projection/* $BUILD1/src/main/java
cp -r org.eclipse.jface.text/src/* $BUILD1/src/main/java
cp -r org.eclipse.jface.text/projection/* $BUILD1/src/main/java
cp -r org.eclipse.core.commands/src/* $BUILD1/src/main/java
cp -r org.eclipse.jface/src/* $BUILD1/src/main/java
cp -r org.eclipse.core.expressions/src/* $BUILD1/src/main/java
cp -r org.eclipse.equinox.bidi/src/* $BUILD1/src/main/java
cp -r org.eclipse.core.resources/src/* $BUILD1/src/main/java
cp -r org.eclipse.core.filesystem/src/* $BUILD1/src/main/java

cp -r org.eclipse.osgi/*.profile $BUILD1/src/main/java
cp -r org.eclipse.osgi/plugin.xml $BUILD1/src/main/java
cp -r org.eclipse.osgi/systembundle.properties $BUILD1/src/main/java
cp -r org.eclipse.osgi/profile.list $BUILD1/src/main/java
cp -r org.eclipse.osgi/META-INF $BUILD1/src/main/java

cp ../debian/org.eclipse.osgi.pom.xml $BUILD1/pom.xml

#==========second artifact=================================================================
mkdir -p $BUILD2/src/main/java

cp -r org.eclipse.jdt.core/compiler/* $BUILD2/src/main/java
cp -r org.eclipse.jdt.core/batch/* $BUILD2/src/main/java
cp -r org.eclipse.jdt.core/model/* $BUILD2/src/main/java
cp -r org.eclipse.jdt.core/codeassist/* $BUILD2/src/main/java
cp -r org.eclipse.jdt.core/search/* $BUILD2/src/main/java
cp -r org.eclipse.jdt.core/dom/* $BUILD2/src/main/java
cp -r org.eclipse.jdt.core/formatter/* $BUILD2/src/main/java
cp -r org.eclipse.jdt.core/eval/* $BUILD2/src/main/java

cp -r org.eclipse.jdt.core/plugin.xml $BUILD2/src/main/java
cp -r org.eclipse.jdt.core/plugin.properties $BUILD2/src/main/java

cp ../debian/org.eclipse.jdt.core.pom.xml $BUILD2/pom.xml

#==========third artifact=================================================================
mkdir -p $BUILD3/src/main/java

cp -r org.eclipse.osgi.compatibility.state/src/* $BUILD3/src/main/java
cp -r org.eclipse.osgi.compatibility.state/OSGI-INF $BUILD3/src/main/java

cp ../debian/org.eclipse.osgi.compatibility.state.pom.xml $BUILD3/pom.xml

#==========fourth artifact=================================================================
mkdir -p $BUILD4/src/main/java

cp -r org.eclipse.jdt.compiler.apt/src/* $BUILD4/src/main/java

cp ../debian/org.eclipse.jdt.compiler.apt.pom.xml $BUILD4/pom.xml

#==========================================================================================
#cd $BUILD1

#mvn -o -Dmaven.repo.local=$REPO -Dmaven.test.skip=true install


