//---------------------------------------------------------------------------
// Copyright (c) 2000 Magnus Danielson. All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

// $Id: Hierarchy.hh,v 1.1 2003/12/04 19:13:18 dmartin Exp $

// $Author: dmartin $
// $Revision: 1.1 $

#ifndef HIERARCHY_HH
#define HIERARCHY_HH

// Standard C and C++ includes
#include <string>
#include <map>
#include <cstdio>
// Project includes
#include "tyvis/SignalBase.hh"

using std::string;
using std::map;

typedef struct Hierarchy_member Hierarchy_member;

#define HIERARCHY_TYPE_BLOCK	1
#define HIERARCHY_TYPE_SIGNAL	2

class Hierarchy
{
public:
	// Constructor and destructor

	/** Constructor */
	Hierarchy();

	/** Destructor */
	~Hierarchy();

	// Create members

	/**
	    Add block member to hierarchy object.
	    \param name Name of block.
	    \param hier Pointer to hierarchy object of block.
	 */
	void	add_block(char * name, Hierarchy * hier);


	/**
		Add signal member to hierarchy object.
		\param	name	Name of signal.
		\param	signal	Pointer to signal object.
	 */
	void	add_signal(char * name, SignalBase * signal);

	// Members access

	/**
		Get the number of members in hierarchy.
		\return		The number of members in hierarchy.
	 */
	unsigned long	get_count();

	/**
		Get the child (name) type.
		\param	name	The name of the child to fetch type of.
		\return		The requested child type.
	 */
	int		get_type(char * name);

	/**
		Get the child hierarchy (name) in this hierarchy.
		\param	name	The name of the child hierarchy to fetch.
		\return		The requested child hierarchy.
	 */
	Hierarchy *	get_hierarchy(char * name);

	/**
		Get the signal (name) in this hierarchy.
		\param	name	The name of the signal to fetch.
		\return		The requested signal.
	 */
	SignalBase *	get_signal(char * name);

	// Dump

	/**
		Dumps the content of the hierarchy onto the file of (fp).
		Indentation depth must be given to offset the members
		correctly.
		\breif	Dumps the content of the hierarchy onto the file of (fp).
		\param	fp	The standard C file pointer to dump content to.
		\param	depth	The indentation depth for the dumping.
	 */
	void		fdump(FILE * fp, int depth);
private:
	// Reference to leader of cell
	Hierarchy *			head;

	// Member list of sect
	map<string,Hierarchy_member *>	members;

	// Maintainance routines

	/**
		Add a new member to hierarchy. To be used by public wrappers.
		\param	name	Name or member entry.
		\param	type	Type of member entry.
		\param	hier	Pointer to child Hierarchy.
		\param	signal	Pointer to named signal.
	 */
	void add_member(char *		name,
			int		type,
			Hierarchy *	hier,
			SignalBase *	signal);
};

#endif /* HIERARCHY_HH */
