//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef TYPES_HH
#define TYPES_HH

#include <iostream>
using std::ostream;

#ifndef ASSERT
#ifdef DEVELOPER_ASSERTIONS
#include <cassert>
#define ASSERT( x ) assert( x )
#else
#define ASSERT( x )
#endif
#endif

class SignalBase;
class VHDLType;

enum SigType { EXPLICIT, NULL_TRANSACTION, G_BUS, IMPLICIT };

enum TransactionType { NORMALTRANSACTION, CANCELTRANSACTION};

enum PortType { IN, OUT, INOUT, BUFFER, LINKAGE };
enum VarType { NORMAL, ACCESS };
// LAST_EVENT is first because it must be updated first in 
// VHDLKernel::updateSignal.  The other attributes depend on this value.
// DO NOT CHANGE THIS.
enum AttribType { LAST_EVENT, EVENT, ACTIVE, LAST_ACTIVE, LAST_VALUE, 
		  DRIVING, DRIVING_VALUE, QUIET, STABLE, TRANSACTION,
		  INVALID};

// This enumeration type tells us the state of the kernel regarding wait
// statements: it is not waiting, waiting inside a procedure, or waitin
// inside a process.
enum WaitiState { NOT_WAITING = -5, WAITING_IN_PROC };

// This enumeration type is used to implement wait statements within a
// procedure.  Three conditions arise:
// 1. The procedure hits a wait statement, and returns.
// 2. The procedure is called to evaluate if the wait has resumed.
// 3. The procedure returns normally (after a VHDL "return" statement).
// These three states are represened by the following enumerations
// reapectively.
enum ProcedureWaitReturn_t {EXECUTE_WAIT_RETURN, RESUME_WAIT_RETURN, 
			    NORMAL_RETURN};

struct Attribute {
  AttribType attrib;
  VHDLType *value;
};

ostream& operator<<(ostream& os, const SigType& st);
ostream& operator<<(ostream& os, const PortType& pt);
ostream& operator<<(ostream& os, const VarType& vt);
ostream& operator<<(ostream& os, const AttribType &at);
ostream& operator<<(ostream& os, const Attribute &at);

#ifdef __DECCXX
typedef long int LONG;  // 8 byte long
#else
typedef long long int LONG; // 4 byte long, 8 byte long long
#endif

LONG str_to_long_long(const char *str);


/** Type for up and down type conversion functions, and resolution
    function ids.  These functions are accessed from a global function
    array.  This is necessary for static elaboration.  We must be able
    to write these function "references" to a file and read it back
    before execution.  This can not be done if write pointers to
    file. */
typedef int TypeConversionFnId_t;

typedef int ResolutionFnId_t;

class VHDLProcess;
class VHDLType;

typedef VHDLType* (*ResolutionFnPtr)(VHDLProcess *, int, VHDLType**);
typedef VHDLType* (*TypeConversionFnPtr)(VHDLProcess *, VHDLType*);

#endif
