#ifndef ARRAY_TYPE_INFO_HH
#define ARRAY_TYPE_INFO_HH

#include "tyvis/TypeInfo.hh"
#include <vector>
using std::vector;

/** 
    This holds info about the array type.
*/
class ArrayTypeInfo : public TypeInfo {
  friend class ArrayType;
public:
  ArrayTypeInfo();

  ArrayTypeInfo( int dim,
		 TypeInfo *elementTypeInfo, 
		 bool unconstrained, 
		 bool compositeResolvedFlag, 
		 ResolutionFnId_t resolutionFunction, 
		 TypeInfo *r1Info, ...);

  ArrayTypeInfo( TypeInfo *elementType,
		 bool,
		 bool,
		 ResolutionFnId_t,
		 const vector<TypeInfo *> &initRanges );

  ArrayTypeInfo(const ArrayTypeInfo&);

  ~ArrayTypeInfo(){
    // Currently not safe due to operator=
    //     for( int i = 0; i < noofDimensions; i++ ){
    //       delete ranges[i];
    //     }
  }
 
  TypeInfo *getRangeInfo(const int) const;
  int get_dimensions() const { return ranges.size(); }
  int get_number_of_elements(int dimension) const;
  ArrayTypeInfo& operator=(const ArrayTypeInfo&);
  TypeInfo *getElementTypeInfo() const { return elementTypeInfo; }

  TypeInfoKind getKind() const { return ARRAY_TYPE_INFO; }

  bool isUnconstrainedArrayType() const { return unconstrainedType; }

  bool isCompositeResolvedType() const { return compositeResolvedType; }

  ResolutionFnId_t getResolutionFunctionId() const { return resolutionFunctionId; }

  VHDLType *createObject(ObjectBase::ObjectType) const;
  
  ArrayInfo getBounds(int) const;
 
  const vector<TypeInfo *> &getRanges() const { return ranges; }
 
protected:
  vector<TypeInfo *> ranges;
  TypeInfo *elementTypeInfo;
  bool   unconstrainedType;
  bool   compositeResolvedType;

  ResolutionFnId_t resolutionFunctionId;
  
private:

};

#endif
