#include "Block.hh"
#include <iostream>
#include <algorithm>
using std::find;
using std::cout;
using std::endl;

Block::Block( const int initSize ){
  expandableArray.reserve( initSize );
}

void*
Block::getElement( const int index ){
  return expandableArray[index];
}

void
Block::removeElement(const int index)  {
  vector<void *>::iterator i = expandableArray.begin();
  i += index;
  expandableArray.erase( i );
}

void*
Block::operator [](const int index) {
  return getElement( index );
}

void 
Block::addElement(void* newElement) {
  if( newElement == 0 ){
    cout << "Adding NULL to block!" << endl;
  }
  void *found = find( newElement );
  if( found == 0 ){
    expandableArray.push_back( newElement );
  }
}

void *
Block::find( void* element ){
  void *retval = 0;
  vector<void *>::iterator found = std::find( expandableArray.begin(),
					      expandableArray.end(),
					      element );
  if( found != expandableArray.end() ){
    retval = *found;
  }
  return retval;
}

int
Block::getNumberOfElements() const {
  return expandableArray.size();
}

void
Block::reset() {
  expandableArray.clear();
}

Block&
Block::operator=(const Block& rhsBlock){
  expandableArray.insert( expandableArray.begin(),
			  rhsBlock.expandableArray.begin(),
			  rhsBlock.expandableArray.end() );		     
  
  return *this;
}
