#include "SourceTypeConvert.hh"
#include "TypeConvert.hh"

SourceTypeConvert::SourceTypeConvert() {
  data = NULL;
  conversionNode = NULL;
}

SourceTypeConvert::~SourceTypeConvert() {
  conversionNode = NULL;
}

VHDLType *
SourceTypeConvert::resolve( VHDLKernel *processPtr, SigType ){
  conversionNode->resolve(processPtr);
  if ( data->getParentCompositeType() != NULL ){
    return data->getParentCompositeType();
  } else {
    return data;
  }
}

void
SourceTypeConvert::setData(VHDLType *inData){
  data = inData;
}

void
SourceTypeConvert::setTypeConvert(TypeConvert *nodePtr){
  conversionNode = nodePtr;
}

