#ifndef TRANSACTION_LIST_HH
#define TRANSACTION_LIST_HH

#include <vector>
using std::vector;

#include "tyvis/Transaction.hh"
class VHDLVTime;

class TransactionList {
public:
  TransactionList( SignalBase &initSignal );
  virtual ~TransactionList();

  bool empty() const;

  /**
     This method does housekeeping on our transaction list.  We can throw
     away transactions that have occured before our current simulation
     time.
  */
  void clean( const VHDLVTime &eraseBefore );
 
 /** Marking is explained in VHDL'93 LRM in section 8.4.1.  */
 void doMarking( const VHDLVTime &transactionTime,
		 Transaction *newTransaction,
		 const VHDLVTime &rejectTime );
  
  /**
     Destroys the current transaction list, and copies passed in list.
  */
  void copy( const TransactionList &source );
  

private:
  /**
     Returns the transactions.
  */
  vector<Transaction *> &getTransactions(){ return myTransactions; }

  vector<Transaction *> myTransactions;
  SignalBase &mySignal;
};

#endif
