#ifndef UNIVERSAL_LONG_LONG_INTEGER_HH
#define UNIVERSAL_LONG_LONG_INTEGER_HH

#include "tyvis/VHDLData.hh"
#include <warped/SerializedInstance.h>
#include <warped/DeserializerManager.h>

class AccessVariable;
class UniversalReal;
class UniversalInteger;

struct UniversalLongLongInteger : public VHDLData {
  friend inline ostream& operator<<(ostream&, const UniversalLongLongInteger&);

  LONG val;

  static const UniversalLongLongInteger &getMax();
  static const UniversalLongLongInteger &getMin();

  virtual VHDLData::UniversalType getUniversalKind() const{
    return UNIVERSAL_LONG_LONG_INTEGER;
  }

  UniversalLongLongInteger(): val(0){}
  UniversalLongLongInteger(int i) : val((LONG) i){}
  UniversalLongLongInteger(LONG i): val(i){}
  UniversalLongLongInteger(char c) : val( (LONG) c - '0' ){}
  UniversalLongLongInteger(bool b) : val( (true == b ? 1LL : 0LL) ){}
  UniversalLongLongInteger(double f) : val( (LONG)f ){}
  UniversalLongLongInteger(float f) : val( (LONG)f ){}

  UniversalLongLongInteger(const UniversalLongLongInteger &i ) : VHDLData(),
								 val( i.val ){}
  UniversalLongLongInteger(const VHDLData &v );

  VHDLData& operator=(const VHDLData& d) {
    val = ((UniversalLongLongInteger*)&d)->val;
    return *this;
  }
  UniversalLongLongInteger& operator=(const UniversalLongLongInteger& i) {
    val = i.val;
    return *this;
  }
  
  UniversalLongLongInteger& operator=(const LONG value) {
    val = value;
    return *this;
  }

  bool operator==( const RValue &compareTo ) const {
    return val == dynamic_cast<const UniversalLongLongInteger &>( compareTo.readVal() );
  }

  
  bool operator!=(const RValue &compareTo ) const {
    return val != dynamic_cast<const UniversalLongLongInteger &>( compareTo.readVal() );
  }

  bool operator > ( const RValue &compareTo ) const{
    return val > dynamic_cast<const UniversalLongLongInteger &>( compareTo.readVal() );
  }

  bool operator >= ( const RValue &compareTo ) const {
    return val >= dynamic_cast<const UniversalLongLongInteger &>( compareTo.readVal() );
  }

  bool operator < ( const RValue &compareTo ) const {
    return val < dynamic_cast<const UniversalLongLongInteger &>( compareTo.readVal() );
  }

  bool operator <= ( const RValue &compareTo ) const {
    return val <= dynamic_cast<const UniversalLongLongInteger &>( compareTo.readVal() );
  }

  bool operator==(const UniversalLongLongInteger& d) const {
    return (val == d.val);
  }

  UniversalLongLongInteger assign(char ch) {
    val = (ch - '0');
    return val;
  }

  operator int() const { return int(val); }

  int savantwrite( AccessVariable & ) const;
  int savantwrite( AccessType & ) const;
  int savantread( AccessVariable & );
  int savantread( AccessType & );
  int savantread(char *) {
    return NORMAL_RETURN;
  }
  int savantwrite( ostringstream &os ) const {
    os << this->val;
    return NORMAL_RETURN;
  }
  
  VHDLData* clone() const {
    return new UniversalLongLongInteger(*this);
  }
  
  int getSize() const { return sizeof(*this); }
  void print(ostream& os = std::cout) const { os << getInt64Value(); }

  static UniversalLongLongInteger typeCast(VHDLData& toCast);

  friend inline LONG longlongint(UniversalLongLongInteger var) { return var.val; }

  static const string &getUniversalLongLongIntegerType(){
    static const string universalLongLongIntegerType = "UniversalLongLongInteger";
    return universalLongLongIntegerType;
  }

  const string &getDataType() const {
    return getUniversalLongLongIntegerType();
  }

  void serialize( SerializedInstance *addTo ) const {
    addTo->addInt64( val );
  }

  static Serializable *deserialize( SerializedInstance *si ){
    return new UniversalLongLongInteger( si->getInt64() );
  }

  static void registerDeserializer(){
    DeserializerManager::instance()->registerDeserializer( getUniversalLongLongIntegerType(),
							   &UniversalLongLongInteger::deserialize );
  }

  int getIntValue() const {
    int retval;
    if( val > INT_MAX ){
      retval = INT_MAX;
    }
    else{
      retval = val;
    }
    return retval;
  }

  LONG getInt64Value() const {
    return val;
  }

  double getDoubleValue() const {
    return (double)val;
  }

  UniversalLongLongInteger vhdlUnaryPlus() const;
  UniversalLongLongInteger vhdlUnaryMinus() const;
  UniversalLongLongInteger vhdlAbs() const;
  UniversalLongLongInteger vhdlPlus( const RValue & ) const;
  UniversalLongLongInteger vhdlMinus( const RValue & ) const;
  UniversalLongLongInteger vhdlMultiply( const RValue & ) const;
  UniversalLongLongInteger vhdlDivide( const RValue & ) const;
  UniversalLongLongInteger vhdlMod( const RValue & ) const;
  UniversalLongLongInteger vhdlRem( const RValue & ) const;
  UniversalLongLongInteger vhdlPow( const RValue & ) const;
  UniversalLongLongInteger vhdlAnd( const RValue & ) const;
  UniversalLongLongInteger vhdlOr( const RValue & ) const;
  UniversalLongLongInteger vhdlNand( const RValue & ) const;
  UniversalLongLongInteger vhdlNor( const RValue & ) const;
  UniversalLongLongInteger vhdlXor( const RValue & ) const;
  UniversalLongLongInteger vhdlXnor( const RValue & ) const;
  UniversalLongLongInteger vhdlNot( const RValue & ) const;
};



inline ostream& operator<<(ostream& os, const UniversalLongLongInteger& i) {
  os << i.val;
  return os;
}

#endif
