#include "UniversalReal.hh"
#include "AccessVariable.hh"
#include "AccessType.hh"
#include "ArrayType.hh"
#include "std_standardPkg.hh"
#include <cmath>
#include <sstream>
using std::ostringstream;
using std::stringstream;

UniversalReal
UniversalReal::typeCast( VHDLData &toCast ){
  switch(toCast.getUniversalKind()){
  case UNIVERSAL_LONG_LONG_INTEGER:
  case UNIVERSAL_INTEGER:
  case UNIVERSAL_REAL:
    return UniversalReal( toCast.getDoubleValue() );
    break;
  default:
    cerr << toCast.getUniversalKind() 
	 << " cannot be type casted into an UniversalReal ! " << endl;
    return UniversalReal(0);
  }
}

UniversalReal::UniversalReal(const VHDLData &v) {
  this->operator=(v);
}

// Here, (DBL_MAX > 1.0E38) has to hold, Required by LRM.
const UniversalReal &
UniversalReal::getMax(){
  static UniversalReal max(1.0E38);
  return max;
}

const UniversalReal &
UniversalReal::getMin(){
  static UniversalReal min(-1.0E38);
  return min;
}

UniversalReal
UniversalReal::unaryPlus() const {
  return *this;
}

UniversalReal
UniversalReal::unaryMinus() const {
  return UniversalReal( -1.0 * getDoubleValue() );
}


UniversalReal
UniversalReal::abs() const {
  return UniversalReal( fabs( getDoubleValue() ));
}

UniversalReal
UniversalReal::plus( const RValue &rhs ) const {
  return UniversalReal( getDoubleValue() + rhs.getDoubleValue() );
}

UniversalReal
UniversalReal::minus( const RValue &rhs ) const {
  return UniversalReal( getDoubleValue() - rhs.getDoubleValue() );
}

UniversalReal
UniversalReal::multiply( const RValue &rhs) const {
  return UniversalReal( getDoubleValue() * rhs.getDoubleValue() );
}

UniversalReal
UniversalReal::divide(const RValue &rhs ) const {
  return UniversalReal(getDoubleValue() / rhs.getDoubleValue());
}

UniversalReal
UniversalReal::pow( const RValue &rhs ) const {
  return UniversalReal( ::pow(getDoubleValue(), rhs.getDoubleValue()));
}

int
UniversalReal::savantwrite(AccessVariable &line) const {
  ostringstream tempStr;
  tempStr << line.getVal() << FILE_DELIMITER << *this;
  
  line.setVal( tempStr.str() );

  return NORMAL_RETURN;
}

int
UniversalReal::savantwrite(AccessType &line) const {
  ostringstream tempStr;
  
  tempStr << line << *this << FILE_DELIMITER << '\0';

  if (line.val != NULL) {
    delete line.val;
  }
  
  line.val = new ArrayType( ObjectBase::VARIABLE,
			    SavantstringType_info,
			    -1,
			    tempStr.str().c_str() );

  return NORMAL_RETURN;
}

int
UniversalReal::savantread(AccessVariable &) {
  return NORMAL_RETURN;
}

int
UniversalReal::savantread(AccessType &line) {
  char *workString = line.val->getString();
  char *input      = new char[strlen(workString) + 1];
  stringstream inputStream;
  
  extractToDelimiter(workString, FILE_DELIMITER, input);

  inputStream << input;
  inputStream >> val;

  delete line.val;

  if (strlen(workString) > 0) {
    line.val = new ArrayType(ObjectBase::VARIABLE, SavantstringType_info, -1, workString);
  }
  else {
    line.val = NULL;
  }

  delete [] workString;
  delete [] input;
    
  return NORMAL_RETURN;
}


