#include "SeverityLevelTest.hh"
#include <warped/SerializedInstance.h>
#include <clutils/StringUtilities.h>

int
SeverityLevelTest::getDefaultValue(){
  static int defaultValue = 3;
  return defaultValue;
}

void 
SeverityLevelTest::setUp(){
  toTest = new SeverityLevel( SeverityLevel::WARNING );
}

void 
SeverityLevelTest::tearDown(){
  delete toTest;
}

void
SeverityLevelTest::testGetUniversalKind(){
  CPPUNIT_ASSERT( toTest->getUniversalKind() == VHDLData::SEVERITY_LEVEL );
}

void
SeverityLevelTest::testGetLength(){
  CPPUNIT_ASSERT( toTest->length() == 1 );
}

void
SeverityLevelTest::testPrint(){
  ostringstream printStream;
  toTest->print( printStream );
  CPPUNIT_ASSERT( "WARNING" == printStream.str() );
}

void
SeverityLevelTest::testEqual(){
  SeverityLevel a(SeverityLevel::WARNING);
  SeverityLevel b(SeverityLevel::WARNING);
  
  CPPUNIT_ASSERT( a == b );
}

void
SeverityLevelTest::testNotEqual(){
  SeverityLevel a(SeverityLevel::WARNING);
  SeverityLevel b(SeverityLevel::NOTE);
  
  CPPUNIT_ASSERT( a != b );
}

void
SeverityLevelTest::testGreater(){
  SeverityLevel a(SeverityLevel::NOTE);
  SeverityLevel b(SeverityLevel::WARNING);
  
  CPPUNIT_ASSERT( b > a );
}

void
SeverityLevelTest::testGreaterEqual(){
  SeverityLevel a(SeverityLevel::NOTE);
  SeverityLevel b(SeverityLevel::WARNING);
  SeverityLevel c(SeverityLevel::WARNING);
  
  CPPUNIT_ASSERT( b >= a );
  CPPUNIT_ASSERT( b >= c );
}

void
SeverityLevelTest::testLess(){
  SeverityLevel a(SeverityLevel::NOTE);
  SeverityLevel b(SeverityLevel::WARNING);
  
  CPPUNIT_ASSERT( a < b );
}

void
SeverityLevelTest::testLessEqual(){
  SeverityLevel a(SeverityLevel::NOTE);
  SeverityLevel b(SeverityLevel::ERROR);
  SeverityLevel c(SeverityLevel::ERROR);
  
  CPPUNIT_ASSERT( a <= c );
  CPPUNIT_ASSERT( b <= c );
}

void
SeverityLevelTest::testClone(){
  SeverityLevel *cloned = dynamic_cast<SeverityLevel *>(toTest->clone());
  CPPUNIT_ASSERT( cloned != 0 );
  CPPUNIT_ASSERT( cloned != toTest );
  CPPUNIT_ASSERT( *cloned == *toTest );
  delete cloned;
}

void
SeverityLevelTest::testSerialization(){
  SerializedInstance *serialized = static_cast<Serializable *>(toTest)->serialize();
  CPPUNIT_ASSERT( serialized->getDataType() == toTest->getDataType() );
  SeverityLevel *deserialized = dynamic_cast<SeverityLevel *>( serialized->deserialize() );
  CPPUNIT_ASSERT( deserialized != 0 );
  CPPUNIT_ASSERT( deserialized != toTest );
  CPPUNIT_ASSERT( *deserialized == *toTest );
  delete deserialized;
}
