//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr and Richard Bilson 2003
// 
// AbortExit.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Fri Dec 19 10:33:58 2003
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Dec 22 14:02:37 2003
// Update Count     : 4
// 

#include <uC++.h>
#include <uIOStream.h>
#include <uSemaphore.h>

enum Mode { SPIN, EXIT, ABORT, EXPLODE } mode;

uTask worker {
    void main() {
        switch( mode ) {
          case SPIN:
	    for ( ;; ) {}
	  case EXIT:
	    uExit( 3 );
	  case ABORT:
	    uAbort( "worker %d %s", 3, "text" );
	  case EXPLODE:
	    kill( getpid(), SIGILL );
	} // switch
    } // main
  public:
    worker( uCluster &c ) : uBaseTask( c ) {}
}; // worker

void uMain::main() {
    if ( argc <= 1 ) {
        uCerr << "usage: " << argv[0] << " [0-3]" << endl;
    } // if
    mode = (Mode)atoi( argv[1] );

    uCluster c;
    uProcessor p(c);
    worker t(c);
    uSemaphore s(0);
    s.P();
} // uMain::main
