//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// DatingTrad.cc -- Exchanging Values Between Tasks using blocking signal
// 
// Author           : Peter A. Buhr
// Created On       : Thu Aug  2 11:47:55 1990
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jun 21 10:21:58 2004
// Update Count     : 65
// 

#include <uC++.h>
#include <uIOStream.h>
#include <uIOManip.h>


uMonitor DatingService {
	int GirlPhoneNo, BoyPhoneNo;
	uCondition GirlWaiting, BoyWaiting;
  public:
	int Girl( int PhoneNo ) {
		if ( BoyWaiting.empty() ) {
			uWait GirlWaiting;
			GirlPhoneNo = PhoneNo;
		} else {
			GirlPhoneNo = PhoneNo;
			uSignalBlock BoyWaiting;
		} // if
		return BoyPhoneNo;
	} // DatingService::Girl

	int Boy( int PhoneNo ) {
		if ( GirlWaiting.empty() ) {
			uWait BoyWaiting;
			BoyPhoneNo = PhoneNo;
		} else {
			BoyPhoneNo = PhoneNo;
			uSignalBlock GirlWaiting;
		} // if
		return GirlPhoneNo;
	} // DatingService::Boy
}; // DatingService

uTask Girl {
	DatingService &TheExchange;

	void main() {
		uYield( rand() % 100 );							// don't all start at the same time
		int PhoneNo = rand() % 10000000;
		int partner = TheExchange.Girl( PhoneNo );
		uCout << uAcquire << "Girl:" << setw(8) << &uThisTask() << " at " << setw(8) << PhoneNo
			<< " is dating Boy  at " << setw(8) << partner << endl << uRelease;
	} // main
  public:
	Girl( DatingService &TheExchange ) : TheExchange( TheExchange ) {
	} // Girl
}; // Girl

uTask Boy {
	DatingService &TheExchange;

	void main() {
		uYield( rand() % 100 );							// don't all start at the same time
		int PhoneNo = rand() % 10000000;
		int partner = TheExchange.Boy( PhoneNo );
		uCout << uAcquire << " Boy:" << setw(8) << &uThisTask() << " at " << setw(8) << PhoneNo
			<< " is dating Girl at " << setw(8) << partner << endl << uRelease;
	} // main
  public:
	Boy( DatingService &TheExchange ) : TheExchange( TheExchange ) {
	} // Boy
}; // Boy


void uMain::main() {
	const int NoOfGirls = 20;
	const int NoOfBoys = 20;

	DatingService TheExchange;
	Girl *girls;
	Boy  *boys;

	girls = new Girl[NoOfGirls]( TheExchange );
	boys  = new Boy[NoOfBoys]( TheExchange );

	delete [] girls;
	delete [] boys;

	uCout << uAcquire << "successful execution" << endl << uRelease;
} // uMain::main

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ DatingTrad.cc" //
// End: //
