//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Ashif S. Harji 1997
// 
// TimedWait.cc -- 
// 
// Author           : Ashif S. Harji
// Created On       : Thu Dec 11 10:17:16 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Aug 27 08:14:14 2004
// Update Count     : 195
// 

#include <uC++.h>
#include <uIOStream.h>
#include <uIOManip.h>
#include <uBarrier.h>
#include <pthread.h>


pthread_mutex_t mutex;
pthread_cond_t waitc;
uBarrier b( 2 );

void *r1main( void *arg ) {
    struct timeval now;
    struct timespec timeout;
    
    pthread_mutex_lock( &mutex );
    gettimeofday( &now, 0 );
    timeout.tv_sec = now.tv_sec + 1;
    timeout.tv_nsec = now.tv_usec * 1000;

    if ( pthread_cond_timedwait( &waitc, &mutex, &timeout ) != ETIMEDOUT ) {
	uAbort( "timeout failed" );
    } // if
    uCout << uAcquire << &uThisTask() << " timedout" << endl << uRelease;	    

    b.block();

    // Test calls which occur increasingly close to timeout value.

    for ( int i = 0; i < 23; i += 1 ) {
	gettimeofday( &now, 0 );
	timeout.tv_sec = now.tv_sec + 1;
	timeout.tv_nsec = now.tv_usec * 1000;
	int rc;

	rc = pthread_cond_timedwait( &waitc, &mutex, &timeout );
	if ( rc ==  ETIMEDOUT ) { 
	    uCout << uAcquire << &uThisTask() << " timedout" << endl << uRelease;
	} else if ( rc == 0 ) {
	    uCout << uAcquire << &uThisTask() << " signalled" << endl << uRelease;
	} else {
	    uAbort( "timeout error\n" );
	} // if

	b.block();
    } // for

    return 0;
}

void *r2main( void *arg ) {
    // Test if timing out works.

    b.block();

    // Test calls which occur increasingly close to timeout value.

    uTimeout( uDuration(0, 100000000) );
    pthread_cond_signal( &waitc );
    b.block();

    uTimeout( uDuration(0, 500000000) );
    pthread_cond_signal( &waitc );
    b.block();

    uTimeout( uDuration(0, 900000000) );
    pthread_cond_signal( &waitc );
    b.block();

    for ( int i = 0; i < 20; i += 1 ) {
	uTimeout( uDuration(0, 999600000) );
	pthread_cond_signal( &waitc );
	b.block();
    } // for

    return 0;
} // r2main

void uMain::main(){
    uProcessor processor[1];				// more than one processor
    pthread_t r1, r2;

    pthread_mutex_init( &mutex, NULL );
    pthread_cond_init( &waitc, NULL );
		
    if ( pthread_create( &r1, NULL, r1main, NULL ) != 0 ) {
	printf( "create thread r1 failure\n" );
	exit( -1 );
    }

    if ( pthread_create( &r2, NULL, r2main, NULL ) != 0 ) {
	printf( "create thread r2 failure\n" );
	exit( -1 );
    }

    pthread_join(r1, NULL);
    pthread_join(r2, NULL);
} // uMain::main


// Local Variables: //
// compile-command: "u++ TimedWait.cc" //
// End: //
