//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uFloat.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Mon Oct 10 08:30:46 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 26 11:35:55 2004
// Update Count     : 28
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>


#ifdef __U_FLOATINGPOINTDATASIZE__
uFloatingPointContext::uFloatingPointContext() : uContext( &uUniqueKey ) {
} // uFloatingPointContext::uFloatingPointContext
#endif // __U_FLOATINGPOINTDATASIZE__


void uFloatingPointContext::uSave() {
    
#if defined( __i386__ )
    // saved by caller
#elif defined( __ia64__ )
    // saved by swapcontext
#elif defined( __sparc__ )
    // saved by caller
#elif defined( __mips__ )
    asm volatile ( "s.d $f20,%0" : : "m" (uFloatingPointData[0]) );
    asm volatile ( "s.d $f22,%0" : : "m" (uFloatingPointData[1]) );
    asm volatile ( "s.d $f24,%0" : : "m" (uFloatingPointData[2]) );
    asm volatile ( "s.d $f26,%0" : : "m" (uFloatingPointData[3]) );
    asm volatile ( "s.d $f28,%0" : : "m" (uFloatingPointData[4]) );
    asm volatile ( "s.d $f30,%0" : : "m" (uFloatingPointData[5]) );
#else
    #error uC++ internal error : unsupported architecture
#endif

} // uFloatingPointContext::uSave


void uFloatingPointContext::uRestore() {
    
#if defined( __i386__ )
    // restored by caller
#elif defined( __ia64__ )
    // restored by swapcontext
#elif defined( __sparc__ )
    // restored by caller
#elif defined( __mips__ )
    asm volatile ( "l.d $f20,%0" : : "m" (uFloatingPointData[0]) );
    asm volatile ( "l.d $f22,%0" : : "m" (uFloatingPointData[1]) );
    asm volatile ( "l.d $f24,%0" : : "m" (uFloatingPointData[2]) );
    asm volatile ( "l.d $f26,%0" : : "m" (uFloatingPointData[3]) );
    asm volatile ( "l.d $f28,%0" : : "m" (uFloatingPointData[4]) );
    asm volatile ( "l.d $f30,%0" : : "m" (uFloatingPointData[5]) );
#else
    #error uC++ internal error : unsupported architecture
#endif

} // uFloatingPointContext::uRestore


// Local Variables: //
// compile-command: "gmake install" //
// End: //
