//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Peter A. Buhr 1997
// 
// uBaseCoroutine.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Sat Sep 27 16:46:37 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Dec 12 09:04:53 2005
// Update Count     : 402
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 

#define __U_KERNEL__
#define __U_PROFILE__
#define __U_PROFILEABLE_ONLY__


#include <uC++.h>
#include <uProfiler.h>
//#include <uDebug.h>


//######################### uBaseCoroutine #########################


void uBaseCoroutine::uCreateCoroutine() {
#ifdef __U_DEBUG__
    last = NULL;					// for error checking
    currSerialOwner = NULL;
    currSerialCount = 0;
#endif // __U_DEBUG__
    notHalted = true;					// must be a non-zero value so detectable after memory is scrubbed
    state = Inactive;

    // exception handling

    uHandlerStackTop = uHandlerStackVisualTop = NULL;
    ResumedObj = NULL;
    TopResumedType = NULL;
    uDAEStack = NULL;
    uUnexpectedRtn = uEHM::uUnexpected;			// initialize default unexpected routine

    // profiling

    uProfileTaskSamplerInstance = NULL;
} // uBaseCoroutine::uCreateCoroutine


uBaseCoroutine::uBaseCoroutine() : uMachContext( uThisCluster().getStackSize() ) {
    uCreateCoroutine();
} // uBaseCoroutine::uBaseCoroutine


uBaseCoroutine::uBaseCoroutine( unsigned int stacksize ) : uMachContext( stacksize ) {
    uCreateCoroutine();
} // uBaseCoroutine::uBaseCoroutine


void uBaseCoroutine::uContextSw() {			// switch between a task and the kernel
    uBaseCoroutine &uCurrCor = uThisCoroutine();	// optimization
    uBaseTask &uCurrTask = uThisTask();

    if ( uCurrTask.uProfileActive && uProfiler::uProfiler_BuiltInRegisterTaskBlock ) { // uninterruptable hooks
	(*uProfiler::uProfiler_BuiltInRegisterTaskBlock)( uProfiler::uProfilerInstance, uCurrTask );
    } // if

    uCurrCor.setState( Inactive );			// set state of current coroutine to inactive
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uBaseCoroutine &)0x%p.uContextSw, uCurrCor:0x%p, uCurrCor.uSP:0x%p, uCurrCor.uStorage:0x%p, uStorage:0x%p\n",
	       this, &uCurrCor, uCurrCor.stackPointer(), uCurrCor.uStorage, uStorage );
#endif // __U_DEBUG_H__
    uCurrCor.save();					// save user specified contexts

    uSwitch( uCurrCor.uStorage, uStorage );		// context switch to kernel
    uCurrCor.restore();					// restore user specified contexts
    uCurrCor.setState( Active );			// set state of new coroutine to active

    uCurrTask.setState( uBaseTask::Running );

    if ( uCurrTask.uProfileActive && uProfiler::uProfiler_BuiltInRegisterTaskUnblock ) { // uninterruptable hooks
	(*uProfiler::uProfiler_BuiltInRegisterTaskUnblock)( uProfiler::uProfilerInstance, uCurrTask );
    } // if
} // uBaseCoroutine::uContextSw


void uBaseCoroutine::uContextSw2() {			// switch between two coroutine contexts
    uBaseCoroutine &uCurrCor = uThisCoroutine();	// optimization
    uBaseTask &uCurrTask = uThisTask();

#ifdef __U_DEBUG__
    // reset task in current coroutine?
    if ( uCurrCor.currSerialCount == uCurrTask.uCurrSerialLevel ) {
	uCurrCor.currSerialOwner = NULL;
    } // if
    
    // check and set for new owner
    if ( currSerialOwner != &uCurrTask ) {
	if ( currSerialOwner != NULL  ) {
	    if ( &currSerialOwner->getCoroutine() != this ) {
		uAbort( "Attempt by task %.256s (0x%p) to activate coroutine %.256s (0x%p) currently executing in a mutex object owned by task %.256s (0x%p).\n"
			"Possible cause is task attempting to logically change ownership of a mutex object via a coroutine.",
			uCurrTask.getName(), &uCurrTask, this->getName(), this, currSerialOwner->getName(), currSerialOwner );
	    } else {
		uAbort( "Attempt by task %.256s (0x%p) to resume coroutine %.256s (0x%p) currently being executed by task %.256s (0x%p).\n"
			"Possible cause is two tasks attempting simultaneous execution of the same coroutine.",
			uCurrTask.getName(), &uCurrTask, this->getName(), this, currSerialOwner->getName(), currSerialOwner );
	    } // if
	}  else {
	    currSerialOwner = &uCurrTask;
	    currSerialCount = uCurrTask.uCurrSerialLevel;
	} // if
    } // if
#endif // __U_DEBUG__

    if ( uCurrTask.uProfileActive && uProfiler::uProfiler_RegisterCoroutineBlock ) {
	(*uProfiler::uProfiler_RegisterCoroutineBlock)( uProfiler::uProfilerInstance, uCurrTask, *this );
    } // if

    THREAD_GETMEM( uSelf )->disableInterrupts();

    uCurrCor.setState( Inactive );			// set state of current coroutine to inactive
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uBaseCoroutine &)0x%p.uContextSw2, uCurrCor:0x%p, uCurrCor.uSP:0x%p\n",
	       this, &uCurrCor, uCurrCor.stackPointer() );
#endif // __U_DEBUG_H__
    uCurrCor.save();					// save user specified contexts
    uCurrTask.currCoroutine = this;			// set new coroutine that task is executing

#if defined( __U_MULTI__ ) && defined( __U_SWAPCONTEXT__ )
#if defined( __linux__ ) && defined( __i386__ )
#if ! defined( __U_PTHREAD__ )
    ((ucontext_t *)(uStorage))->uc_mcontext.gregs[REG_GS] = THREAD_GETMEM( ldtValue );
#endif // ! __U_PTHREAD__
#elif defined( __linux__ ) && defined( __x86_64__ )
#if ! defined( __U_PTHREAD__ )
    #error uC++ : internal error, unsupported architecture
#endif // ! __U_PTHREAD__
#elif defined( __linux__ ) && defined( __ia64__ )
    ((ucontext_t *)(uStorage))->uc_mcontext.sc_gr[13] = (unsigned long)THREAD_GETMEM( threadPointer );
#elif defined( __solaris__ ) && defined( __sparc__ ) && ! defined( __U_PTHREAD__ )
    ((ucontext_t *)(uStorage))->uc_mcontext.gregs[REG_G7] = (int)(THREAD_GETMEM( uSelf ) );
#elif defined( __irix__ ) && defined( __mips__ )
    // No thread register => nothing needs to be set in the mcontext
#else
    #error uC++ : internal error, unsupported architecture
#endif
#ifdef __U_ONETIMER__
    if ( &uThisProcessor() == uKernelModule::uSystemProcessor ) {
	sigdelset( (sigset_t *)&(((ucontext_t *)(uStorage))->uc_sigmask), SIGALRM );
    } else {
	sigaddset( (sigset_t *)&(((ucontext_t *)(uStorage))->uc_sigmask), SIGALRM );
    } // if
#endif // __U_ONETIMER__
#endif // __U_MULTI__ && __U_SWAPCONTEXT__
#if  defined( __U_MULTI__ ) && defined( __U_ONETIMER__ ) && defined( __ia64__ )
    if ( &uThisProcessor() == uKernelModule::uSystemProcessor ) {
	sigdelset( &((uContext_t *)(uStorage))->uSigmask, SIGALRM );
    } else {
	sigaddset( &((uContext_t *)(uStorage))->uSigmask, SIGALRM );
    } // if
#endif // __U_MULTI__ && __U_ONETIMER__ && __ia64__

    uSwitch( uCurrCor.uStorage, uStorage );		// context switch to specified coroutine
    uCurrCor.restore();					// restore user specified contexts
    uCurrCor.setState( Active );			// set state of new coroutine to active

    THREAD_GETMEM( uSelf )->enableInterrupts();

    // also appears in uCoroutineMain::uCoroutineMain
    if ( uCurrTask.uProfileActive && uProfiler::uProfiler_RegisterCoroutineUnblock ) {
	(*uProfiler::uProfiler_RegisterCoroutineUnblock)( uProfiler::uProfilerInstance, uCurrTask );
    } // if
} // uBaseCoroutine::uContextSw2


void uBaseCoroutine::uCoFinish() {			// resumes the coroutine that first resumed this coroutine
    notHalted = false;
    _starter->uContextSw2();
    uAbort( "(uBaseCoroutine &)0x%p.uCoFinish() : internal error, CONTROL NEVER REACHES HERE!", this );
} // uBaseCoroutine::uCoFinish


void uBaseCoroutine::resume() {				// restarts the coroutine's main where last suspended
    uBaseCoroutine &c = uThisCoroutine();		// optimization

    if ( &c != this ) {					// resume to oneself ?
#ifdef __U_DEBUG__
        if ( ! notHalted ) {				// check if terminated
	    uAbort( "Attempt by coroutine %.256s (0x%p) to resume terminated coroutine %.256s (0x%p).\n"
		    "Possible cause is terminated coroutine's main routine has already returned.",
		    c.getName(), &c, getName(), this );
	} // if
#endif // __U_DEBUG__
	last = &c;
	uContextSw2();
    } // if
    _Enable <uBaseCoroutine::Failure>;			// implicit poll
} // uBaseCoroutine::resume


void uBaseCoroutine::suspend() {			// restarts the coroutine that most recently resumed this coroutine
#ifdef __U_DEBUG__
    if ( last == NULL ) {
	uAbort( "Attempt to suspend coroutine %.256s (0x%p), which has never been resumed.\n"
		"Possible cause is a suspend executed in a member called by a coroutine user rather than by the coroutine main.",
		getName(), this );
    } // if
    if ( ! last->notHalted ) {				// check if terminated
	    uAbort( "Attempt by coroutine %.256s (0x%p) to suspend back to terminated coroutine %.256s (0x%p).\n"
		    "Possible cause is terminated coroutine's main routine has already returned.",
		    uThisCoroutine().getName(), &uThisCoroutine(), last->getName(), last );
    } // if
#endif // __U_DEBUG__
    last->uContextSw2();
    _Enable <uBaseCoroutine::Failure>;			// implicit poll
} // uBaseCoroutine::suspend


const char *uBaseCoroutine::setName( const char *n ) {
    const char *prev = name;
    name = n;

    if ( uThisTask().uProfileActive && uProfiler::uProfiler_RegisterSetName ) { 
	(*uProfiler::uProfiler_RegisterSetName)( uProfiler::uProfilerInstance, *this, name ); 
    } // if
    return prev;
} // uBaseCoroutine::setName

const char *uBaseCoroutine::getName() const {
    // storage might be uninitialized or scrubbed
    return ( name == NULL || name == (const char *)-1 ) ? "*unknown*" : name;
} // uBaseCoroutine::getName


uBaseCoroutine::Failure::Failure( const char *const msg ) : uKernelFailure( msg ) {
} // uBaseCoroutine::Failure::Failure

uBaseCoroutine::Failure::~Failure() {
} // uBaseCoroutine::Failure::~Failure

void uBaseCoroutine::Failure::defaultTerminate() const {
    uAbort( "(uBaseCoroutine &)0x%p : %.256s.", &uThisCoroutine(), message() );
} // uBaseCoroutine::Failure::defaultTerminate


uBaseCoroutine::UnHandledException::UnHandledException( const char *const msg ) : Failure( msg ), origFailedCor( uThisCoroutine() ) {
    multiple = false;
    uEHM::uStrncpy( origFailedCorName, origFailedCor.getName(), uEHMMaxName );
} // uBaseCoroutine::Failure::Failure

uBaseCoroutine::UnHandledException::~UnHandledException() {
} // uBaseCoroutine::Failure::~Failure

const uBaseCoroutine &uBaseCoroutine::UnHandledException::origSource() const {
    return origFailedCor;
} // uBaseCoroutine::origSource

const char *uBaseCoroutine::UnHandledException::origName() const {
    return origFailedCorName;
} // uBaseCoroutine::origName

void uBaseCoroutine::UnHandledException::defaultTerminate() const {
    if ( ! multiple ) {
	uAbort( "(uBaseCoroutine &)0x%p : Unhandled exception in coroutine %.256s raised non-locally from resumed coroutine %.256s (0x%p), which was terminated due to %s.",
		&uThisCoroutine(), uThisCoroutine().getName(), sourceName(), &source(), message() );
    } else {
	uAbort( "(uBaseCoroutine &)0x%p : Unhandled exception in coroutine %.256s raised non-locally from coroutine %.256s (0x%p), "
		"which was terminated due to a series of unhandled exceptions -- originally %s inside coroutine %.256s (0x%p).",
		&uThisCoroutine(), uThisCoroutine().getName(), sourceName(), &source(), message(), origName(), &origSource() );
    } // if
} // uBaseCoroutine::UnHandledException::defaultTerminate


// Local Variables: //
// compile-command: "gmake install" //
// End: //
