//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Russell Mok 1997
// 
// uEHM.cc -- 
// 
// Author           : Russell Mok
// Created On       : Sun Jun 29 00:15:09 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Dec 12 09:00:21 2005
// Update Count     : 478
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
//#include <uDebug.h>

#include <cxxabi.h>
#include "unwind-cxx.h"					// include file copied from gcc 3.4, needed for reraise from a catch-any
#include <cstring>					// strlen, strncpy, strcpy

#if __GNUC__ == 3 && __GNUC_MINOR__ < 4 && !defined( __INTEL_COMPILER ) // TEMPORARY: bug in uncaught_exception, correction copied from gcc 3.4
// Copyright (C) 2001 Free Software Foundation, Inc.
namespace __cxxabiv1 {
    // Returns the type_info for the currently handled exception [15.3/8], or
    // null if there is none.
    extern "C" void *
    __cxa_begin_catch (void *exc_obj_in) throw()
    {
	_Unwind_Exception *exceptionObject
	    = reinterpret_cast <_Unwind_Exception *>(exc_obj_in);
	__cxa_eh_globals *globals = __cxa_get_globals ();
	__cxa_exception *prev = globals->caughtExceptions;
	__cxa_exception *header = __get_exception_header_from_ue (exceptionObject);

	// Foreign exceptions can't be stacked here.  If the exception stack is
	// empty, then fine.  Otherwise we really have no choice but to terminate.
	// Note that this use of "header" is a lie.  It's fine so long as we only
	// examine header->unwindHeader though.
	if (header->unwindHeader.exception_class != __gxx_exception_class)
	    {
		if (prev != 0)
		    std::terminate ();

		// Remember for end_catch and rethrow.
		globals->caughtExceptions = header;

		// ??? No sensible value to return; we don't know what the 
		// object is, much less where it is in relation to the header.
		return 0;
	    }

	int count = header->handlerCount;
	if (count < 0)
	    // This exception was rethrown from an immediately enclosing region.
	    count = -count + 1;
	else
	    {
		count += 1;
		globals->uncaughtExceptions -= 1;
	    }
	header->handlerCount = count;

	if (header != prev)
	    {
		header->nextException = prev;
		globals->caughtExceptions = header;
	    }

	return header->adjustedPtr;
    }
} // namespace __cxxabiv1
#endif // __GNUC__ == 3 && __GNUC_MINOR__ < 4 && ! __INTEL_COMPILER


//######################### std::{C++ exception routines} ########################


void uEHM::uTerminate() {
    char ExName[uEHMMaxName + sizeof("...")];		// room for "...\0"
    char ResName[uEHMMaxName + sizeof("...")];

    getCurrentEventName( uThrowF, ExName, uEHMMaxName );
    getCurrentEventName( uResumeF, ResName, uEHMMaxName );

    bool exception = ExName[0] != '\0';			// optimization
    bool resumption = ResName[0] != '\0';
    
    if ( ! exception && ! resumption ) {
	uAbort( "Attempt to rethrow/reraise but no active exception.\n"
		"Possible cause is a rethrow/reraise not directly or indirectly performed from a catch clause." );
    } // if
    
    uAbort( "Propagation failed to find a matching handler.\n"
	    "Possible cause is a missing try block with appropriate catch clause for specified or derived exception type\n"
	    "or throwing an exception from within a destructor while propagating an exception.\n"
	    "%s%s%s%s%s",
	    (exception  ? "Type of last active exception: "  : ""), (exception  ? ExName  : ""), (exception && resumption ? "\n" : ""),
	    (resumption ? "Type of last active resumption: " : ""), (resumption ? ResName : "") ); // uAbort puts a "\n"
} // uEHM::uTerminate

void uEHM::uTerminateHandler() {
    try {
	(*uThisTask().uTerminateRtn)();
	uEHM::uTerminate();
    } catch( ... ) {
	uEHM::uTerminate();
    } // try
} // uEHM::uTerminateHandler

void uEHM::uUnexpected() {
    std::terminate();
} // uEHM::uTerminate

void uEHM::uUnexpectedHandler() {
    (*uThisCoroutine().uUnexpectedRtn)();
    std::terminate();
} // uEHM::uUnexpectedHandler

std::terminate_handler std::set_terminate( std::terminate_handler func ) throw() {
    uBaseTask &t = uThisTask();
    std::terminate_handler prev = t.uTerminateRtn;
    t.uTerminateRtn = func;
    return prev;
} // std::set_terminate

std::unexpected_handler std::set_unexpected( std::unexpected_handler func ) throw() {
    uBaseCoroutine &c = uThisCoroutine();		// optimization
    std::unexpected_handler prev = c.uUnexpectedRtn;
    c.uUnexpectedRtn = func;
    return prev;
} // std::set_unexpected


//######################### uEHM::uAsyncAEMsg ########################


uEHM::uAsyncAEMsg::uAsyncAEMsg( const uDualClass &ex, const uFlagT f ) : flag( f ), uHidden( false ) {
    ae = ex.duplicate();
} // uEHM::uAsyncAEMsg::uAsyncAEMsg

uEHM::uAsyncAEMsg::~uAsyncAEMsg() {
    delete ae;
} // uEHM::uAsyncAEMsg::~uAsyncAEMsg


//######################### uEHM::uAsyncAEMsgBuffer ########################


// msg queue for nonlocal exceptions in a coroutine

uEHM::uAsyncAEMsgBuffer::uAsyncAEMsgBuffer() {
} // uAsyncAEMsgBuffer::uAsyncAEMsgBuffer

uEHM::uAsyncAEMsgBuffer::~uAsyncAEMsgBuffer() {
    uCSpinLock dummy( lock );
    for ( uAsyncAEMsg *tmp = drop(); tmp; tmp = drop() ) {
	delete tmp;
    } // for
} // uEHM::uAsyncAEMsgBuffer::~uAsyncAEMsgBuffer

void uEHM::uAsyncAEMsgBuffer::uAddMsg( uAsyncAEMsg *msg ) {
    uCSpinLock dummy( lock );
    add( msg );
} // uEHM::uAsyncAEMsgBuffer::uAddMsg

uEHM::uAsyncAEMsg *uEHM::uAsyncAEMsgBuffer::uRmMsg() {
    uCSpinLock dummy( lock );
    return drop();
} // uEHM::uAsyncAEMsgBuffer::uRmMsg

uEHM::uAsyncAEMsg *uEHM::uAsyncAEMsgBuffer::uRmMsg( uAsyncAEMsg *msg ) {
    // Only lock at the end or the start of the list as these are the only
    // places where interference can occur.

    if ( msg == tail() || msg == head() ) {
	uCSpinLock dummy( lock );
	remove( msg );
    } else {
	remove( msg );
    } // if
    return msg;
} // uEHM::uAsyncAEMsgBuffer::uRmMsg

uEHM::uAsyncAEMsg *uEHM::uAsyncAEMsgBuffer::uNextVisible( uAsyncAEMsg *msg ) {
    // find the next msg node that is visible or null
    do {						// do-while because current node could be visible
	msg = succ( msg );
    } while ( msg && msg->uHidden );
    return msg;
} // uEHM::uAsyncAEMsgBuffer::uNextVisible


//######################### uDualClass ########################


uEHM::uDualClass::uDualClass( const char *const msg ) : src( NULL ) {
    uStrncpy( uEHM::uDualClass::msg, msg, uEHMMaxMsg );	// copy message
}; // uEHM::uDualClass::uDualClass

uEHM::uDualClass::~uDualClass() {}

const char *uEHM::uDualClass::message() const { return msg; }
const uBaseCoroutine &uEHM::uDualClass::source() const { return *src; }
const char *uEHM::uDualClass::sourceName() const { return src != NULL ? srcName : "*unnamed*"; }

void uEHM::uDualClass::setSrc( uBaseCoroutine &cor ) {
    src = &cor;
    uStrncpy( srcName, cor.getName(), uEHMMaxName );	// copy source name
} // uEHM::uDualClass::setSrc

const uEHM::uDualClass &uEHM::uDualClass::setOriginalThrower( const void * p ) const {
    // Calls to this routine are generated by the translator at each throw
    // site. Because the exception object being thrown may be const, this
    // routine still has to modify the exception object. Hence, the need for
    // the const cast.
    const_cast< uEHM::uDualClass * >(this)->uStaticallyBoundObject = p;
    return *this;
} // uEHM::uDualClass::setOriginalThrower

void uEHM::uDualClass::defaultTerminate() const {
} // uEHM::uDualClass::defaultTerminate

void uEHM::uDualClass::defaultResume() const {
    stackThrow();
    // CONTROL NEVER REACHES HERE!
} // uEHM::uDualClass::defaultResume



//######################### uEHM::uThrowClass ########################


uEHM::uThrowClass::uThrowClass( const char *const msg ) : uDualClass( msg ) {}
uEHM::uThrowClass::~uThrowClass() {}

#ifdef __DEBUG__
void uEHM::uThrowClass::defaultResume() const {
    uAbort( "uThrowClass object cannot be casted to a raise-able object." );
} // uEHM::uThrowClass::defaultResume
#endif // __DEBUG__


//######################### uEHM::uResumeClass ########################


void uEHM::uResumeClass::stackThrow() const {
    uAbort( "uResumeClass object cannot be thrown." );
} // uEHM::uResumeClass::stackThrow

uEHM::uResumeClass::uResumeClass( const char *const msg ) : uDualClass( msg ) {}
uEHM::uResumeClass::~uResumeClass() {}

#ifdef __DEBUG__
void uEHM::uResumeClass::defaultTerminate() const {
    uAbort( "uResumeClass object cannot be casted to a throw-able object." );
} // uEHM::uResumeClass::defaultTerminate
#endif // __DEBUG__

void uEHM::uResumeClass::defaultResume() const {
    uTerminate();
} // uEHM::uResumeClass::defaultResume


//######################### uEHM::uResumptionHandlers ########################


uEHM::uResumptionHandlers::uResumptionHandlers( uHandlerBase *const table[], const unsigned int size ) : size( size ), table( table ) {
    uBaseCoroutine &c = uThisCoroutine();		// optimization
    uNext = c.uHandlerStackTop;
    uConseqNext = c.uHandlerStackVisualTop;
    c.uHandlerStackTop = this;
    c.uHandlerStackVisualTop = this;
} // uEHM::uResumptionHandlers::uResumptionHandlers

uEHM::uResumptionHandlers::~uResumptionHandlers() {
    uBaseCoroutine &c = uThisCoroutine();		// optimization
    c.uHandlerStackTop = uNext;
    c.uHandlerStackVisualTop = uConseqNext;
} // uEHM::uResumptionHandlers::~uResumptionHandlers


//######################### uEHM::uDeliverAEStack ########################


uEHM::uDeliverAEStack::uDeliverAEStack( bool f, const std::type_info **t, unsigned int msg ) : uDeliverFlag( f ), table_size( msg ), event_table( t ) {
    // the current node applies to all exceptions when table_size is 0
    uBaseCoroutine &c = uThisCoroutine();		// optimization
    next = c.uDAEStack;
    c.uDAEStack = this;
} // uEHM::uDeliverAEStack::uDeliverAEStack

uEHM::uDeliverAEStack::~uDeliverAEStack() {
    uThisCoroutine().uDAEStack = next;
} // uEHM::uDeliverAEStack::~uDeliverAEStack


//######################### uEHM::uResumeWorkHorseInit ########################


// Initialization and finalization when handling a signalled event after
// finding a handler. This ensures the two different resuming handler
// hierarchies are properly maintained.  As well, it maintains the currently
// handled resumption object for reraise.

class uEHM::uResumeWorkHorseInit {
    uResumptionHandlers *prevVisualTop;
    uDualClass *prevResumption;
  public:
    uResumeWorkHorseInit( uResumptionHandlers *h, uDualClass & newResumption ) {
	uBaseCoroutine &c = uThisCoroutine();		// optimization
	prevResumption = c.ResumedObj;
	c.ResumedObj = &newResumption;
	c.TopResumedType = &typeid(newResumption);
	uBaseCoroutine &current = c;
	prevVisualTop = current.uHandlerStackVisualTop;
	current.uHandlerStackVisualTop = h;
    } // uEHM::uResumeWorkHorseInit::uResumeWorkHorse

    ~uResumeWorkHorseInit() {
	uBaseCoroutine &c = uThisCoroutine();		// optimization
	c.ResumedObj = prevResumption;
	if ( ! std::uncaught_exception() ) {		// update top, unless it's a forceful unwind
	    c.TopResumedType = prevResumption ? &typeid(prevResumption) : NULL;
	} // if
	c.uHandlerStackVisualTop = prevVisualTop;
    } // uEHM::uResumeWorkHorseInit::~uResumeWorkHorse
}; // uEHM::uResumeWorkHorseInit


//######################### uEHM::uEHMAutoResourceCleanup ########################

// Used by uPoll to ensure a handled message is removed from the queue and its
// memory deallocated. These actions are done in the destructor to ensure the
// clean-up is performed even when an exception is thrown.  Unwinding the stack
// causes the uEHMAutoResourceCleanup object to be destroyed and hence the
// destructor to be called.

class uEHM::uEHMAutoResourceCleanup {
    uAsyncAEMsg *msg;
    uAsyncAEMsgBuffer &buf;
  public:
    uEHMAutoResourceCleanup( uAsyncAEMsg *msg, uAsyncAEMsgBuffer &buf ) : msg( msg ), buf( buf ) {}

    ~uEHMAutoResourceCleanup() {
	buf.uRmMsg(msg);
	delete msg;
    } // uEHM::uEHMAutoResourceCleanup::~uEHMAutoResourceCleanup
}; // uEHM::uEHMAutoResourceCleanup


//######################### uEHM ########################


#ifdef __U_DEBUG__
static void Check( uBaseCoroutine &target, const char *kind ) {
    if ( &target == NULL || &target == (uBaseCoroutine *)-1 || *((void **)&target) == NULL || *((void **)&target) == (void *)-1 ) {
	uAbort( "Attempt by task %.256s (0x%p) to %s a nonlocal exception at target 0x%p, but the target is invalid or has been deleted",
		uThisTask().getName(), &uThisTask(), kind, &target );
    } // if
} // Check
#endif // __U_DEBUG__


void uEHM::asyncToss( const uDualClass &ex, uBaseCoroutine &target, uFlagT f, bool rethrow ) {
#ifdef __U_DEBUG__
    Check( target, f == uResumeF ? "resume" : "throw" );
#endif // __U_DEBUG__

    if ( target.getState() != uBaseCoroutine::Halt ) {
	uAsyncAEMsg *temp = new uAsyncAEMsg( ex, f );
	uBaseCoroutine &cor = uThisCoroutine();
	if ( ! rethrow ) {				// reset current raiser ?
	    temp->ae->setOriginalThrower( (void *)&cor );
	    temp->ae->setSrc( cor );
	} // if
	target.uAsyncAEBuf.uAddMsg( temp );
    } // if
} // uEHM::asyncToss

void uEHM::asyncReToss( uBaseCoroutine &target, uFlagT f ) {
    uDualClass *r;

    if (f == uResumeF) {
	r = getCurrentResumption();
	if ( r == NULL ) {
	    r = getCurrentException();
	}//if
    } else {
	r = getCurrentException();
	if ( r == NULL ) {
	    r = getCurrentResumption();
	} // if
    } // if
    
    if ( r == NULL ) {					// => there is nothing to resume => terminate
	uTerminateHandler();
    } else {
	asyncToss( *r, target, f, true );
    } // if
} // uEHM::asyncReToss


void uEHM::Throw( const uDualClass &ex ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "uEHM::Throw( uDualClass::ex:0x%p ) from task %.256s (0x%p)\n", &ex, uThisTask().getName(), &uThisTask() );
#endif // __U_DEBUG_H__
    ex.stackThrow();
    // CONTROL NEVER REACHES HERE!
} // uEHM::Throw

void uEHM::ReThrow() {
    uDualClass *e = getCurrentException();		// optimization
    if ( e == NULL ) {
	e = getCurrentResumption();
    } // if

    if ( e != NULL ) {
	e->stackThrow();
    } // if
    throw;
} // uEHM::ReThrow


void uEHM::Resume( const uDualClass &ex ) {
    uResumeWorkHorse( ex, true );
} // uEHM::Resume

void uEHM::ReResume() {
    uDualClass *r = getCurrentResumption();		// optimization

    if ( r == NULL ) {
	r = getCurrentException();
    } // if

    if ( r == NULL ) {					// => there is nothing to resume => terminate
	uTerminateHandler();
    } else {						// => there is something to resume
	uResumeWorkHorse( *r, true );	
    } // if
}; // uEHM::ReResume


// Check for and handle pending nonlocal exceptions.

bool uEHM::uPoll() {
    uAsyncAEMsgBuffer &msgbuf = uThisCoroutine().uAsyncAEBuf;
    uAsyncAEMsg *ae_msg = msgbuf.head();		// find first node in queue

  if ( ae_msg == NULL ) return false;

    if ( ae_msg->uHidden ) {
	ae_msg = msgbuf.uNextVisible( ae_msg );		// from there, find first visible node
    } // if

    // For each visible node, check if responsible for its delivery. If yes,
    // hide it from any recursive uPoll call, handle the event, and remove it
    // from the queue through the automatic resource clean-up.

    while ( ae_msg != NULL ) {
    	if ( deliverable_exception( ae_msg->ae->uGetEventType() ) ) {
	    // Note, implicit context switches only call uYieldNoPoll(), hence
	    // uPoll can only be called from uResumeWorkHorse again, which is a
	    // safe recursion.
	    ae_msg->uHidden = true;                     // hide node from recursive children of uPoll
	    uDualClass *ae = ae_msg->ae;
	    
	    // Recover memory allocated for async event message. Resuming
	    // handler should not destroyed raised exception regardless of
	    // whether the exception is normal or nonlocal.

	    uEHMAutoResourceCleanup dummy_var( ae_msg, msgbuf ); // This ensures removal and deletion of the node at end of block.
	                                                        // Necessary because of return or throw.

	    if ( ae_msg->flag == uThrowF ) {		// throw the event
		ae->stackThrow();
		// CONTROL NEVER REACHES HERE!
	    } // if
	    uResumeWorkHorse( *ae, false );		// handle event, potential recursion! also potential exception
	    
	    ae_msg = msgbuf.uNextVisible(ae_msg);	// advance to next visible node

	    return true;
	    // NOTE: AE_MSG IS DESTROYED HERE !!
	} else {
	    ae_msg = msgbuf.uNextVisible(ae_msg);	// advance to next visible node (without deleting)
	} // if
    } // while

    // NOTE: finalizer is destroyed here, sets the progress flag to its old
    // value, i.e., the first level turns it off

    return false;
} // uEHM::uPoll


uEHM::uDualClass *uEHM::getCurrentException() {
    __cxxabiv1::__cxa_eh_globals *globals = __cxxabiv1::__cxa_get_globals();
    if ( globals != NULL ) {
	__cxxabiv1::__cxa_exception *header = globals->caughtExceptions;	
	if ( header != NULL ) {			// handling an exception and want to turn it into resumption
	    return (uEHM::uDualClass*)((char *)header + sizeof(__cxxabiv1::__cxa_exception)); 
	} // if
    } // if
    return NULL;
} // uEHM::getCurrentException

uEHM::uDualClass *uEHM::getCurrentResumption() {
    return uThisCoroutine().ResumedObj;			// optimization
} // uEHM::getCurrentResumption

const std::type_info * uEHM::getTopResumptionType() {
    return uThisCoroutine().TopResumedType;
} // uEHM::getCurrentResumptionType()


char *uEHM::getCurrentEventName( uFlagT f, char *s1, size_t n ) {
    const std::type_info *t;

    if ( f == uResumeF ) {
	t = uEHM::getTopResumptionType();
    } else {
	t = __cxxabiv1::__cxa_current_exception_type();
    } // if

    if ( t != NULL ) {
	int status;
	char *s2 = __cxxabiv1::__cxa_demangle( t->name(), 0, 0, &status );
	uStrncpy( s1, s2, n );
	free( s2 );
    } else {
	s1[0] = '\0';
    } // if
    return s1;
} // uEHM::getCurrentExceptionName


char *uEHM::uStrncpy( char *s1, const char *s2, size_t n ) {
    strncpy( s1, s2, n );
    if ( strlen( s2 ) > n ) {				// name too long ?
	strcpy( &s1[n], "..." );			// add 4 character ...
    } // if
    return s1;
} // uEHM::uStrncpy


bool uEHM::uMatch_exception_type( const std::type_info *derived_type, const std::type_info *parent_type ) {
    // return true if derived_type event is derived from parent_type event
    void *dummy;
#ifdef __DEBUG__
    if ( ! parent_type ) uAbort( "internal error, error in setting up guarded region." );
#endif // __DEBUG__
    return parent_type->__do_catch( derived_type, &dummy, 0 );
} // uEHM::uMatch_exception_type


bool uEHM::deliverable_exception( const std::type_info *event_type ) {
    for ( uDeliverAEStack *tmp = uThisCoroutine().uDAEStack; tmp; tmp = tmp->next ) {
	if ( tmp->table_size == 0 ) {			// table_size == 0 is a short hand for all exceptions
	    return tmp->uDeliverFlag;
	} // if

	for ( int i = 0; i < tmp->table_size; i += 1 ) {
	    if ( uMatch_exception_type( event_type, tmp->event_table[i] ) ) {
		return tmp->uDeliverFlag;
	    } // if
	} // for
    } // for
    return false;
} // uEHM::deliverable_exception


// Find and execute resumption handlers. If conseq == false, it means a
// non-consequential resumption (i.e., one newly raised outside of handling
// code) is being handled; hence, begin looking for handlers at the real top of
// the stack. If conseq == true, it means a consequential resumption is being
// handled, but in order to avoid recursive handling, should not consider
// earlier resumption handlers. In this case, the virtual top
// (uHandlerStackVisualTop) of the handler stack is used.

void uEHM::uResumeWorkHorse( const uDualClass &ex, const bool conseq ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "uEHM::uResumeWorkHorse( ex:0x%p, conseq:%d ) from task %.256s (0x%p)\n",
	       &ex, conseq, uThisTask().getName(), &uThisTask() );
#endif // __U_DEBUG_H__

    const std::type_info *raisedtype = ex.uGetEventType();
    uResumptionHandlers *tmp = (conseq) ? uThisCoroutine().uHandlerStackVisualTop : uThisCoroutine().uHandlerStackTop;

    while ( tmp ) {
#ifdef __U_DEBUG_H__
	uDebugPrt( "uEHM::uResumeWorkHorse tmp:0x%p, raisedtype:0x%p\n", tmp, raisedtype );
#endif // __U_DEBUG_H__

	uResumptionHandlers *next = (conseq) ? tmp->uConseqNext : tmp->uNext;

	// search all resumption handlers in the same handler clause
	for ( unsigned int i = 0; i < tmp->size; i += 1 ) {
	    uHandlerBase *elem = tmp->table[i];		// optimization
	    const void *bound = ex.getOriginalThrower();
#ifdef __U_DEBUG_H__
	    uDebugPrt( "uEHM::uResumeWorkHorse table[%d]:0x%p, originalThrower:0x%p, EventType:0x%p, bound:0x%p\n",
		       i, elem, elem->originalThrower, elem->EventType, bound );
#endif // __U_DEBUG_H__
	    // if (no binding OR binding match) AND (type match OR resume_any) => handler found
	    if ( ( elem->originalThrower == 0 || bound == elem->originalThrower ) &&
		 ( elem->EventType == 0 || uMatch_exception_type( raisedtype, elem->EventType ) ) ) {
#ifdef __U_DEBUG_H__
		uDebugPrt( "uEHM::uResumeWorkHorse match\n" );
#endif // __U_DEBUG_H__
		uResumeWorkHorseInit newStackVisualTop( next, (uDualClass &)ex );
		elem->uHandler( (uDualClass &)ex );
		return;					// return after handling the exception
	    } // if
	} // for
	tmp = next;					// next resumption handler clause
    } // while

    // cannot find a handler, use the default handler
    uResumeWorkHorseInit newStackVisualTop( NULL, (uDualClass &)ex ); // record the current resumption
    ex.defaultResume();					// default handler can change the exception
} // uEHM::uResumeWorkHorse


// Local Variables: //
// compile-command: "gmake install" //
// End: //
