dnl AM_NEED_PERMISSIVE
dnl checks if the compiler needs the -fpermissive flag to compile (gcc v>=2.95)
dnl and adds it to CXXFLAGS otherwise, adds -Wall
dnl
AC_DEFUN(AM_NEED_PERMISSIVE,
[
AC_MSG_CHECKING(if c++ compiler needs -fpermissive flag)
save_CFLAGS="$CFLAGS"
save_CC="$CC"
CFLAGS=
CC="$CXX"
AC_TRY_COMPILE([
  class Test {
  public:
    int (Test::*p)(void);
    int func(void) { return 0; }
    Test(void) {
      p = &func;
    }
  };
], [ ], [
  dnl we don't need -fpermissive, use -Wall
  CXXFLAGS="-Wall $CXXFLAGS"
  AC_MSG_RESULT(no)
], [
  dnl we need -fpermissive, check if it's available
  AC_MSG_RESULT(yes)
  AC_MSG_CHECKING(if c++ compiler accepts -fpermissive flag)
  CFLAGS=-fpermissive
  AC_TRY_COMPILE([
    class Test {
    public:
      int (Test::*p)(void);
      int func(void) { return 0; }
      Test(void) {
        p = &func;
      }
    };
  ], [ ], [ CXXFLAGS="-fpermissive $CXXFLAGS"; AC_MSG_RESULT(yes) ], [
    AC_MSG_RESULT(no)
    AC_MSG_ERROR(Unable to determine proper c++ compiler flags!)
  ])
])
CFLAGS="$save_CFLAGS"
CC="$save_CC"
])
