/* ==================================================== ======== ======= *
 *
 *  ucolor.hh
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _ucolor_h
#define	_ucolor_h
//pragma ident	"@(#)ucolor.hh	ubit:03.04.02"
#include <ubit/uprop.hpp>

/** Active Color Property.
 */
class UColor : public UProp {
public:
  /// predefined color constants.
  static UColor none, inherit, white, black, grey, lightgrey, darkgrey, 
    navy, blue, red, green, yellow, lightyellow, orange, wheat, teal,
    disabled;
  
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  UColor();
  ///< creates a new UColor with a defaut value (black).

  UColor(const UColor&);
  ///< creates a new UColor that is a copy of another UColor.

  UColor(const char *color_spec);
  UColor(const UStr& color_spec);
  /**< creates a new UColor from an ASCII color spec.
   * this color spec. can be a predefined color name (such as "SteelBlue") 
   * or a RGB spec. such as "#rrggbb" (refer to X manual for details) */

  // UColor(unsigned long pixel);
  // creates a new UColor from an X Pixel value.

  friend UColor& ucolor(const UColor& c) {return *new UColor(c);}
  friend UColor& ucolor(const char* c)   {return *new UColor(c);}
  friend UColor& ucolor(const UStr& c)   {return *new UColor(c);}
  ///< creator shortcut that is equivalent to: *new UColor().

  ~UColor();

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  UColor& operator=(const UColor&);
  ///< sets color (same as set() but not virtual).

  virtual void set(const UColor&);
  virtual void set(const char* color_spec);
  virtual void set(const UStr& color_spec);
  ///< changes color (same as operator = but virtual).

  virtual bool equals(const UColor&) const;
  ///< returns true if colors are identical.

  //unsigned long getPixel() const; {return pixel;}
  ///< returns the corresponding X Pixel.

  const char* getCharSpec() const;
  ///< returns the ASCII color representation (if defined, null otherwise)

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  virtual void update();
  ///< update parents' graphics.

  bool realize(class UDisp*);
  /**< 
   * [impl] allocates physical resources.
   * this function is automatically called when this color is used
   * for the first time. There no need to call it in client code except
   * for loading colors in advance.
   * - note: the argument can be the UAppli (the Application Context) */

#ifndef NO_DOC
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // implementation

  UColor(const UColor&, u_modes);
  UColor(class UColorImpl*, u_modes); 

  UColorImpl& getImpl() const {return *ci;}
  virtual void putProp(class UContext*, class UCtrl*);

protected:
  uptr<class UColorImpl> ci;
#endif
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

/** Active Background Color Property.
 */
class UBgcolor : public UColor {
public:
  static UBgcolor none, inherit, white, black, grey, lightgrey, darkgrey, 
    navy, blue, red, green, yellow, lightyellow, orange, wheat, teal;
  ///< predefined color constants.

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  UBgcolor();
  UBgcolor(const UColor&);
  UBgcolor(const char* color_spec);
  UBgcolor(const UStr& color_spec); 
  ///< constructors: same as UColor except that default color is white.

  friend UBgcolor& ubgcolor(const UColor& c) {return *new UBgcolor(c);}
  friend UBgcolor& ubgcolor(const char* c)   {return *new UBgcolor(c);}
  friend UBgcolor& ubgcolor(const UStr& c)   {return *new UBgcolor(c);}
  ///< creator shortcut that is equivalent to: *new UBgcolor().

  UBgcolor& operator=(const UColor&);
  ///< sets color (same as UColor::set() but not virtual).

#ifndef NO_DOC
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // implementation

  UBgcolor(const UColor&, u_modes);
  UBgcolor(class UColorImpl*, u_modes); 

  virtual void putProp(class UContext*, class UCtrl*);
#endif
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

