/*
 This file is part of Ubuntu-it Menu.

 Ubuntu-it Menu is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 Ubuntu-it Menu is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Ubuntu-it Menu.  If not, see http://www.gnu.org/licenses/.

 The copy of the GNU General Public License can be found here:
 chrome://ubuntuit/locale/GPLv2License.txt
*/

var ubuntuitUrl = {

	closePopup: function(event){
		var element = event.target.parentNode;

		while (element) {
			if (element.nodeName == "menupopup" ) {
				element.hidePopup();
			}
			element = element.parentNode;
		}
	},

	getURL: function(url) {
		var win = Components.classes["@mozilla.org/appshell/window-mediator;1"].
		getService(Components.interfaces.nsIWindowMediator).
		getMostRecentWindow("navigator:browser");
		return win.document.getElementById("ubuntuiturl-bundle").getString(url);
	},

	openLink: function(event, url) {
		if (event && event.button != 0)
		{
			getBrowser().addTab(unescape(this.getURL(url)));
// 			this.closePopup(event);
		} else {
			loadURI(unescape(this.getURL(url)));
		}
	},

	openClearLink: function(event, url) {
		if (event && event.button != 0)
		{
			getBrowser().addTab(unescape(url));
//			this.closePopup(event);
		} else {
			loadURI(unescape(url));
		}
	},

	searchWiki: function(event, type) {
		var cerca = window._content.document.getSelection();
		var tipo
		if (type.indexOf('titoli') == 0) {
			tipo = '&titlesearch=Titoli';
		} else {
			tipo = '&fullsearch=Testo';
		}
		var ricerca = prompt("Wiki Ubuntu-it - Cerca nei " + type, cerca);
		if (ricerca != null) {
			var url = "http://wiki.ubuntu-it.org/Documentazione/Indice?action=fullsearch&context=180&value=" + ricerca + tipo;
			this.openClearLink(event, url);
		}
	},
}