#!/usr/bin/env python
# 
# 2009-03-30
# This will create a report of bugs with and without a package in a New or 
# Confirmed state reported since a specified, sys.argv[1], date.  The bug
# report will also include the gravity assigned to the bug.
# The gravity is a combination of points associated with bug tags and whether
# or not the bug is private.  Additionally, the quantity of duplicates,
# subscribers and users affected is added to the gravity.
#
# Copyright 2009 Canonical, Ltd
# Author: Brian Murray <brian@ubuntu.com>
# Licensed under the GNU General Public License, version 3.

from launchpadlib.launchpad import Launchpad, EDGE_SERVICE_ROOT, STAGING_SERVICE_ROOT
from launchpadlib.errors import HTTPError
from launchpadlib.credentials import Credentials
from operator import itemgetter
from cgi import escape

import os, sys

cachedir = os.path.expanduser("~/.launchpadlib/cache/")

if not os.path.exists(cachedir):
    os.makedirs(cachedir,0700)

script_name = sys.argv[0].split("/")[-1].split('.')[0]

credfile = os.path.expanduser('~/.launchpadlib/%s.cred' % script_name)

try:
    credentials = Credentials()
    credentials.load(open(credfile))
    launchpad = Launchpad(credentials, EDGE_SERVICE_ROOT, cachedir)
except:
    launchpad = Launchpad.get_token_and_login(script_name, EDGE_SERVICE_ROOT, cachedir)
    launchpad.credentials.save(open(credfile,"w",0600)) 
    
def save_entry(entry):
    try:
        entry.lp_save()
    except HTTPError, error:
        print error.content
    else:
        print "Did not get expected HTTPError!"

# commonly used things
ubuntu = launchpad.distributions['ubuntu']

tasks = ubuntu.searchTasks(status=['New','Confirmed'],order_by='-datecreated')

since = sys.argv[1]

bugcontrol = launchpad.people['ubuntu-bugcontrol']

primary = launchpad.load('https://api.edge.launchpad.net/beta/ubuntu/+archive/primary')

importances = { 'Critical':1, 'High':2, 'Medium':3, 'Low':4, 'Wishlist':5, 'Undecided':6 }

statuses = { "Won't Fix":1, 'New':2, 'Incomplete':3, 'Confirmed':4, 'Triaged':5, 'In Progress':6, 'Fix Committed':7, 'Fix Released':8 } 

bc_list = []

for participant in bugcontrol.participants:
    bc_list.append(participant.name)

# write to this file
datafile = open('bugs-since-%s.html' % since, 'w')

templatefile = open('template.html', 'r')

for line in templatefile:
    if line.strip() == "<!-- *** Title Space *** -->":
        datafile.write("New and Confirmed bug tasks opened since %s\n" % since)
    elif line.strip() == "<!-- *** Header Space *** -->":
        datafile.write("New and Confirmed bug tasks opened since %s\n" % since)
    elif line.strip() == "<!-- *** Paragraph Space *** -->":
        datafile.write("All of the column headers are sortable give them a click!<br>Curious about how gravity is computed? See the legend at the bottom of the page.")
    elif line.strip() == "<!-- *** Table Header Space *** -->":
        table_header = "<th></th>"  # bug number in this column
        table_header += "<th>Summary</th>"
        table_header += "<th>In</th>"
        table_header += "<th>Importance</th>"
        table_header += "<th>Status</th>"
        table_header += '<th class="default-sort initial-sort">Gravity</th>'
        table_header += "<th>Date Created</th>"
        table_header += "\n"
        datafile.write(table_header)
    elif line.strip() == "<!-- *** Table Body Space *** -->":
        for task in tasks:
            # date_ changes depending on which revision of lplib you have :-(
            if task.date_created.strftime('%Y-%m-%d') > since:
            #if task.date_created[:10] > since:
                try:
                    if 'needs-packaging' in task.bug.tags:
                        continue
                    weight = 0
                    dupe_count = len(task.bug.duplicates)
                    sub_count = len(task.bug.subscriptions)
                    user_count = task.bug.users_affected_count
                    tag_weights = { 'apport-bug':50, 'apport-package':100, 'apport-crash':100,
                                    'apport-failed-retrace':-250, 
                                    'regression-potential':150, 'regression-release':200,
                                    'regression-proposed':250, 'regression-updates':300 }
                    tag_set = set()
                    for tag in tag_weights:
                        tag_set.add(tag)
                    bug_tag_set = set()
                    for tag in task.bug.tags: 
                        bug_tag_set.add(tag)
                    if tag_set.intersection(bug_tag_set):
                        for tag in tag_set.intersection(bug_tag_set):
                            weight += tag_weights[tag]
                    # any odd numbered gravity is a private bug
                    if task.bug.private:
                        weight += 151
                    if task.bug.owner.name in bc_list:
                        weight += 400
                    weight += ( 6*dupe_count + 4*sub_count + 2*user_count )
                    if weight >= 0:
                        table_row = "<tr>"
                        table_row += "<td>%s</td>" % task.bug.id
                        table_row += "<td><a href='http://launchpad.net/bugs/%s'>%s</a></td>" % (task.bug.id, escape(task.bug.title.encode('utf-8')))
                        src_name = "%s" % task.bug_target_display_name
                        if src_name == 'Ubuntu':
                            table_row += "<td>%s</td>" % src_name.encode('utf-8')
                        else:
                            try:
                                table_row += "<td><a href='http://launchpad.net/ubuntu/+source/%s' title='%s'>%s</a></td>" % ( src_name.split(' ')[0].encode('utf-8'), primary.getPublishedSources(source_name=src_name.split(' ')[0],status='Published',pocket='Release',exact_match=True)[0].component_name.encode('utf-8'), src_name.encode('utf-8') )
                            except IndexError:
                                table_row += "<td>%s</td>" % src_name.encode('utf-8')
                        importance = task.importance.encode('utf-8')
                        table_row += '<td><span class="sortkey">%s</span>%s</td>' % ( importances[importance], importance )
                        status = task.status.encode('utf-8')
                        table_row += '<td><span class="sortkey">%s</span>%s</td>' % ( statuses[status], status )
                        table_row += "<td>%s</td>" % ( weight )
                        # date changes depending on which revision of lplib you have :-(
                        table_row += "<td>%s</td>" % task.date_created.strftime('%Y-%m-%d %H:%M:%S') 
                        #table_row += "<td>%s</td." % task.date_created[:19]
                        table_row += "</tr>"
                        table_row += "\n"
                        datafile.write(table_row)
                except HTTPError, error:
                    print "There was an error with LP: #%s: %s" % (task.title.split(' ')[1].replace('#',''), error.content)
            else:
                break
    elif line.strip() == "<!-- *** Last Paragraph Space *** -->":
        datafile.write("<table border=1>\n")
        datafile.write("<thead><tr><th align=center>Item</th><th align=center>Value</th></tr></thead>\n")
        datafile.write("<tr><td>Bug Control member</td><td>400</td></tr>\n")
        for k,v in sorted(tag_weights.items(), key=itemgetter(1), reverse=True):
            datafile.write("<tr><td>%s tag</td><td>%s</td>\n" % (k,v))
        datafile.write("<tr><td>private bug</td><td>151</td></tr>\n")
        datafile.write("<tr><td>num duplicates</td><td>x*6</td></tr>\n")
        datafile.write("<tr><td>num subscribers</td><td>x*4</td></tr>\n")
        datafile.write("<tr><td>num users affected</td><td>x*2</td></tr>\n")
        datafile.write("<table>\n")
    else:
        datafile.write(line)
datafile.close()
